/*
 * Decompiled with CFR 0.152.
 */
package com.simba.wbapi;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.simba.services.params.SortConfig;
import com.simba.wbapi.MockController;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class MockController {
    @Autowired
    private SortConfig sortConfig;

    @PostMapping(value={"/v1/auth/login"})
    public String login(@RequestBody LoginRequest request) throws JsonProcessingException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("employee_id", 637941);
        dataMap.put("employee_full_name", "\u0413\u0440\u0438\u0446\u0430\u0439 \u0421\u0435\u0440\u0433\u0435\u0439 \u0412\u0430\u043b\u0435\u0440\u044c\u0435\u0432\u0438\u0447");
        HashMap<String, Object> mainMap = new HashMap<String, Object>();
        mainMap.put("code", 200);
        mainMap.put("message", "success");
        mainMap.put("codeMsg", null);
        mainMap.put("data", dataMap);
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(mainMap);
        return json;
    }

    @PostMapping(value={"/v1/auth/logout"})
    public String logout(@RequestBody LogoutRequest request) {
        return "logout performed";
    }

    @GetMapping(value={"/v1/sort/item"})
    public ResponseEntity<String> getItemSortingInfo(@RequestParam String wb_barcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wb_scanned_barcode", wb_barcode);
        map.put("outbound_chutes", (String)new /* Unavailable Anonymous Inner Class!! */);
        return new ResponseEntity((Object)JSON.toJSONString(map), HttpStatus.OK);
    }

    @PostMapping(value={"/v1/sort/item"})
    public String saveItemSortingResult(@RequestBody ItemSortingResult result) {
        return "Item sorting result received and saved by WCS";
    }

    @PostMapping(value={"/v1/tare"})
    public String notifyTareAssign(@RequestBody TareAssignInformation info) {
        return "WCS received tare assign information";
    }

    @DeleteMapping(value={"/v1/tare"})
    public String notifyTareRelease(@RequestBody TareReleaseInformation info) {
        return "WCS received tare release information";
    }

    @PostMapping(value={"/v1/chute"})
    public String notifyChuteOpen(@RequestBody ChuteInformation info) {
        return "WCS received chute and tare information";
    }

    @DeleteMapping(value={"/v1/chute"})
    public String notifyChuteClose(@RequestBody ChuteInformation info) {
        return "WCS received tare release information";
    }

    @PostMapping(value={"/v1/box/"})
    public LastMileBoxLabelInformation getLastMileBoxLabelInfo(@RequestBody LastMileSortBoxInformation info) {
        LastMileBoxLabelInformation labelInfo = new LastMileBoxLabelInformation();
        labelInfo.setQr_code(info.getQr_code());
        labelInfo.setLabel_information("Final destination information");
        labelInfo.setGate_chute_number(1);
        return labelInfo;
    }

    @PostMapping(value={"/v1/box/temp"})
    public String notifyTempBoxCreation(@RequestBody TemporaryLastMileBoxInformation info) {
        return "WCS received the information about the box";
    }

    @GetMapping(value={"/v1/box/events"})
    public String getBoxEvents() {
        return "The box is assigned or removed successfully";
    }

    @PostMapping(value={"/v1/box/gate/sort"})
    public String saveBoxSortingResult(@RequestBody LastMileBoxGateSortingResult result) {
        return "Box sorting result received and saved by WCS";
    }

    static /* synthetic */ SortConfig access$000(MockController x0) {
        return x0.sortConfig;
    }
}

