/*
 * Decompiled with CFR 0.152.
 */
package com.simba.wbapi;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.gson.Gson;
import com.simba.services.params.SortConfig;
import com.simba.services.params.SorterParams;
import com.simba.wbapi.RequestEntities;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiClientExample {
    private static final Logger log = LoggerFactory.getLogger(ApiClientExample.class);
    @Resource
    private SortConfig sortConfig;
    @Resource
    private SorterParams sorterParams;
    private static final String LOGIN_URL = "/v1/auth/login";
    private static final String LOGOUT_URL = "/v1/auth/logout";
    private static final String ITEM_SORTING_INFO_URL = "/v1/sort/item";
    private static final String SAVE_ITEM_SORTING_RESULT_URL = "/v1/sort/item";
    private static final String NOTIFY_TARE_ASSIGN_URL = "/v1/tare";
    private static final String NOTIFY_TARE_RELEASE_URL = "/v1/tare";
    private static final String NOTIFY_CHUTE_OPEN_URL = "/v1/chute";
    private static final String NOTIFY_CHUTE_CLOSE_URL = "/v1/chute";
    private static final String GET_LAST_MILE_BOX_LABEL_INFO_URL = "/v1/box/";
    private static final String NOTIFY_TEMP_BOX_CREATION_URL = "/v1/box/temp";
    private static final String GET_BOX_EVENTS_URL = "/v1/box/events";
    private static final String SAVE_BOX_SORTING_RESULT_URL = "/v1/box/gate/sort";
    private final Gson gson = new Gson();

    private String sendHttpRequest(String method, String url, Object payload) throws IOException {
        String errorMsg;
        String responseBody;
        HttpGet request;
        String logInfo = "Sending HTTP request: " + method + " " + url + " with payload: " + payload;
        log.info(logInfo);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        switch (method.toUpperCase()) {
            case "GET": {
                request = new HttpGet(url);
                break;
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(url);
                if (payload != null) {
                    String jsonPayload = this.gson.toJson(payload);
                    StringEntity entity = new StringEntity(jsonPayload);
                    httpPost.setEntity((HttpEntity)entity);
                    httpPost.setHeader("Content-type", "application/json");
                }
                request = httpPost;
                break;
            }
            case "DELETE": {
                HttpDelete httpDelete = new HttpDelete(url);
                if (payload != null) {
                    httpDelete.setHeader("Content-type", "application/json");
                }
                request = httpDelete;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method: " + method);
            }
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = responseBody = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        if (statusCode == 200) {
            log.info("Sending HTTP request: " + method + " " + url + " with payload: " + payload + "response 200 : " + responseBody);
            return responseBody;
        }
        if (statusCode == 404) {
            errorMsg = "\u8bf7\u6c42\u5931\u8d25\uff0c\u672a\u627e\u5230\u8d44\u6e90: " + responseBody;
            String error = "Sending HTTP request: " + method + " " + url + " with payload: " + payload + "response 404 : " + errorMsg;
            log.info(error);
            throw new RuntimeException("#404# " + responseBody);
        }
        if (statusCode == 500) {
            errorMsg = "WCS \u53d1\u751f\u9519\u8bef: " + responseBody;
            String error = "Sending HTTP request: " + method + " " + url + " with payload: " + payload + "response 500 : " + errorMsg;
            log.info(error);
            throw new RuntimeException("#500# " + responseBody);
        }
        log.info("logInfo:" + logInfo + ": result:" + statusCode + ":" + responseBody);
        return null;
    }

    public String login(RequestEntities.LoginRequest request) throws IOException, InterruptedException {
        try {
            String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + LOGIN_URL;
            return this.sendHttpRequest("POST", url, (Object)request);
        }
        catch (Exception e) {
            log.info("login {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    public String logout(RequestEntities.LogoutRequest request) throws IOException, InterruptedException {
        try {
            String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + LOGOUT_URL;
            return this.sendHttpRequest("POST", url, (Object)request);
        }
        catch (Exception e) {
            log.info("login {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    public String getItemSortingInfo(String[] wbBarcodes, int inFeedPlaceId) throws IOException, InterruptedException {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()).append("/v1/sort/item").append("?");
            for (String barcode : wbBarcodes) {
                String encodedBarcode = URLEncoder.encode(barcode, "UTF-8");
                urlBuilder.append("wb_barcode=").append(encodedBarcode).append("&");
            }
            urlBuilder.append("in_feed_place_id=").append(inFeedPlaceId);
            String url = urlBuilder.toString();
            return this.sendHttpRequest("GET", url, null);
        }
        catch (Exception e) {
            log.info("getItemSortingInfo Error {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    public String getItemSortingInfo(String wbBarcodesString, int inFeedPlaceId) throws IOException, InterruptedException {
        String[] wbBarcodes = wbBarcodesString.split(",");
        return this.getItemSortingInfo(wbBarcodes, inFeedPlaceId);
    }

    public String getItemSortingInfoSingle(String wbBarcode, int inFeedPlaceId) throws IOException, InterruptedException {
        return this.getItemSortingInfo(new String[]{wbBarcode}, inFeedPlaceId);
    }

    @Deprecated
    public String getItemSortingInfoOld(String wbBarcode) throws IOException, InterruptedException {
        return this.getItemSortingInfo(new String[]{wbBarcode}, 1);
    }

    public String saveItemSortingResult(String wbScannedBarcode, int sortedChuteNumber, String ts, Integer sortPlaceId, Integer employeeId) throws IOException, InterruptedException {
        try {
            String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + "/v1/sort/item";
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("wb_scanned_barcode", wbScannedBarcode);
            payload.put("sorted_chute_number", sortedChuteNumber);
            payload.put("ts", ts);
            if (sortPlaceId != null) {
                payload.put("sort_place_id", sortPlaceId);
            }
            if (employeeId != null) {
                payload.put("employee_id", employeeId);
            }
            return this.sendHttpRequest("POST", url, payload);
        }
        catch (Exception e) {
            log.info("saveItemSortingResult Error {}", (Object)e.getMessage());
            return e.getMessage();
        }
    }

    public String saveItemSortingResult(String wbScannedBarcode, int sortedChuteNumber, int sortPlaceId, int employeeId) throws IOException, InterruptedException {
        String ts = ZonedDateTime.now(ZoneId.of("+03:00")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
        return this.saveItemSortingResult(wbScannedBarcode, sortedChuteNumber, ts, Integer.valueOf(sortPlaceId), Integer.valueOf(employeeId));
    }

    public void notifyTareAssign(int tareBarcode, int chuteNumber, int sortPlaceId, int employeeId) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + "/v1/tare";
        HashMap<String, Integer> payload = new HashMap<String, Integer>();
        payload.put("tare_barcode", tareBarcode);
        payload.put("chute_number", chuteNumber);
        payload.put("sort_place_id", sortPlaceId);
        payload.put("employee_id", employeeId);
        this.sendHttpRequest("POST", url, payload);
    }

    public void notifyTareRelease(int tareBarcode, int chuteNumber, int sortPlaceId, int employeeId, List<String> sortedItemsBarcodes) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + "/v1/tare";
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("tare_barcode", tareBarcode);
        payload.put("chute_number", chuteNumber);
        payload.put("sort_place_id", sortPlaceId);
        payload.put("employee_id", employeeId);
        if (sortedItemsBarcodes != null) {
            payload.put("sorted_items_barcodes", sortedItemsBarcodes);
        }
        this.sendHttpRequest("DELETE", url, payload);
    }

    public void notifyChuteOpen(int chuteNumber, int sortPlaceId, Integer tareBarcode) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + "/v1/chute";
        HashMap<String, Integer> payload = new HashMap<String, Integer>();
        payload.put("chute_number", chuteNumber);
        payload.put("sort_place_id", sortPlaceId);
        if (tareBarcode != null) {
            payload.put("tare_barcode", tareBarcode);
        }
        this.sendHttpRequest("POST", url, payload);
    }

    public void notifyChuteClose(int chuteNumber, int sortPlaceId, Integer tareBarcode) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + "/v1/chute";
        HashMap<String, Integer> payload = new HashMap<String, Integer>();
        payload.put("chute_number", chuteNumber);
        payload.put("sort_place_id", sortPlaceId);
        if (tareBarcode != null) {
            payload.put("tare_barcode", tareBarcode);
        }
        this.sendHttpRequest("DELETE", url, payload);
    }

    public String getLastMileBoxLabelInfo(String qrCode, int sortPlaceId, List<String> sortedItemsBarcodes) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + GET_LAST_MILE_BOX_LABEL_INFO_URL;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("qr_code", qrCode);
        payload.put("sort_place_id", sortPlaceId);
        if (sortedItemsBarcodes != null) {
            payload.put("sorted_items_barcodes", sortedItemsBarcodes);
        }
        return this.sendHttpRequest("POST", url, payload);
    }

    public void notifyTempBoxCreation(String qrCode, int sortPlaceId) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + NOTIFY_TEMP_BOX_CREATION_URL;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("qr_code", qrCode);
        payload.put("sort_place_id", sortPlaceId);
        this.sendHttpRequest("POST", url, payload);
    }

    public String getBoxEvents() throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + GET_BOX_EVENTS_URL;
        return this.sendHttpRequest("GET", url, null);
    }

    public void saveBoxSortingResult(String qrCode, String sortedGateNumber, int sortPlaceId) throws IOException, InterruptedException {
        String url = (StringUtils.isNotEmpty((CharSequence)this.sorterParams.getSapUrl()) ? this.sorterParams.getSapUrl() : this.sortConfig.getSapUrl()) + SAVE_BOX_SORTING_RESULT_URL;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("qr_code", qrCode);
        payload.put("sorted_gate_number", sortedGateNumber);
        payload.put("sort_place_id", sortPlaceId);
        this.sendHttpRequest("POST", url, payload);
    }
}

