/*
 * Decompiled with CFR 0.152.
 */
package com.simba.wbapi;

import com.simba.common.util.R;
import com.simba.wbapi.ApiClientExample;
import com.simba.wbapi.RequestEntities;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/test"})
public class ApiClientController {
    @Autowired
    private ApiClientExample apiClientExample;

    @PostMapping(value={"/login"})
    public R<?> login(@RequestBody RequestEntities.LoginRequest request) throws IOException, InterruptedException {
        return R.ok((String)this.apiClientExample.login(request));
    }

    @PostMapping(value={"/logout"})
    public R<?> logout(@RequestBody RequestEntities.LogoutRequest request) throws IOException, InterruptedException {
        return R.ok((String)this.apiClientExample.logout(request));
    }

    @GetMapping(value={"/item-sorting-info"})
    public R<?> getItemSortingInfo(@RequestParam String wbBarcode) throws IOException, InterruptedException {
        return R.ok((String)this.apiClientExample.getItemSortingInfo(wbBarcode, 1));
    }

    @PostMapping(value={"/save-item-sorting-result"})
    public R<?> saveItemSortingResult(@RequestBody RequestEntities.SaveItemSortingResultRequest request) throws IOException, InterruptedException {
        return R.ok((String)this.apiClientExample.saveItemSortingResult(request.getWb_scanned_barcode(), request.getSorted_chute_number(), request.getSort_place_id().intValue(), request.getEmployee_id().intValue()));
    }

    @PostMapping(value={"/notify-tare-assign"})
    public void notifyTareAssign(@RequestBody RequestEntities.NotifyTareAssignRequest request) throws IOException, InterruptedException {
        this.apiClientExample.notifyTareAssign(request.getTare_barcode(), request.getChute_number(), request.getSort_place_id(), request.getEmployee_id());
    }

    @DeleteMapping(value={"/notify-tare-release"})
    public void notifyTareRelease(@RequestParam int tareBarcode, @RequestParam int chuteNumber, @RequestParam int sortPlaceId, @RequestParam int employeeId, @RequestParam List<String> sortedItemsBarcodes) throws IOException, InterruptedException {
        this.apiClientExample.notifyTareRelease(tareBarcode, chuteNumber, sortPlaceId, employeeId, sortedItemsBarcodes);
    }

    @PostMapping(value={"/notify-chute-open"})
    public void notifyChuteOpen(@RequestBody RequestEntities.NotifyChuteOpenRequest request) throws IOException, InterruptedException {
        this.apiClientExample.notifyChuteOpen(request.getChute_number(), request.getSort_place_id(), request.getTare_barcode());
    }

    @DeleteMapping(value={"/notify-chute-close"})
    public void notifyChuteClose(@RequestParam int chuteNumber, @RequestParam int sortPlaceId, @RequestParam(required=false) Integer tareBarcode) throws IOException, InterruptedException {
        this.apiClientExample.notifyChuteClose(chuteNumber, sortPlaceId, tareBarcode);
    }

    @PostMapping(value={"/get-last-mile-box-label-info"})
    public String getLastMileBoxLabelInfo(@RequestBody RequestEntities.GetLastMileBoxLabelInfoRequest request) throws IOException, InterruptedException {
        return this.apiClientExample.getLastMileBoxLabelInfo(request.getQr_code(), request.getSort_place_id(), request.getSorted_items_barcodes());
    }

    @PostMapping(value={"/notify-temp-box-creation"})
    public void notifyTempBoxCreation(@RequestBody RequestEntities.NotifyTempBoxCreationRequest request) throws IOException, InterruptedException {
        this.apiClientExample.notifyTempBoxCreation(request.getQr_code(), request.getSort_place_id());
    }

    @GetMapping(value={"/get-box-events"})
    public String getBoxEvents() throws IOException, InterruptedException {
        return this.apiClientExample.getBoxEvents();
    }

    @PostMapping(value={"/save-box-sorting-result"})
    public void saveBoxSortingResult(@RequestBody RequestEntities.SaveBoxSortingResultRequest request) throws IOException, InterruptedException {
        this.apiClientExample.saveBoxSortingResult(request.getQr_code(), request.getSorted_gate_number(), request.getSort_place_id());
    }
}

