/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class BoxInfoAllocTask {
    private static final Logger log = LoggerFactory.getLogger(BoxInfoAllocTask.class);
    private final SlotService slotService;

    @Scheduled(initialDelay=5000L, fixedDelay=1000L)
    private void doTask() {
        try {
            for (SlotInfo slotInfo : this.slotService.getSlotInfoList()) {
                boolean res;
                if (!slotInfo.isNeedAllocBoxCode() || (res = this.slotService.checkSlotIsTrash(slotInfo.getSlotId()))) continue;
                slotInfo.alloc();
            }
        }
        catch (Exception ex) {
            log.error("[BoxInfoAllocTask.doAllocBoxInfo] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public BoxInfoAllocTask(SlotService slotService) {
        this.slotService = slotService;
    }
}

