/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.simba.common.command.CommandExecutor;
import com.simba.common.command.RC;
import com.simba.databases.entity.TtPacketOffInfo;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.services.SlotService;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.SortConfig;
import com.simba.task.ExpiredTask;
import com.simba.web.client.WebSortInfoCmd;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SortInfoService {
    private static final Logger log = LoggerFactory.getLogger(SortInfoService.class);
    private final ConcurrentHashMap<String, SortInfo> sortInfos = new ConcurrentHashMap();
    private final BlockingQueue<SortInfo> failedQueue = new LinkedBlockingQueue();
    private final ConcurrentHashMap<String, Integer> roadSlots = new ConcurrentHashMap();
    private final AtomicInteger roadSlotSerial = new AtomicInteger(0);
    @Resource
    private SlotService slotService;
    @Resource
    private SortConfig sortConfig;
    @Resource
    private ITtPacketOffInfoService packetOffInfoService;
    @Resource
    private ExpiredTask expiredTask;

    public void addSortInfo(SortInfo sortInfo) {
        if (sortInfo == null) {
            return;
        }
        this.sortInfos.put(sortInfo.getCarId(), sortInfo);
    }

    public SortInfo createSortInfo() {
        SortInfo sortInfo = new SortInfo();
        sortInfo.setSortingId(this.createSortingId());
        sortInfo.setCurrentTime(System.currentTimeMillis());
        return sortInfo;
    }

    public SortInfo getSortInfo(String key) {
        return (SortInfo)this.sortInfos.get(key.toLowerCase());
    }

    public int getSortInfoCount() {
        return this.sortInfos.size();
    }

    public boolean containsSortInfo(String key) {
        return this.sortInfos.containsKey(key);
    }

    public void handleSortInfoResult(SortInfo sortInfo) {
        int errorCode = sortInfo.getErrorCodeSVR();
        if (errorCode != 0) {
            sortInfo.getSlotsList().clear();
            List slots = this.slotService.getTrashSlots(errorCode, sortInfo.getSorterId());
            if (slots != null) {
                sortInfo.getSlotsList().addAll(slots);
            }
        } else {
            this.createSiteCodeValue(sortInfo);
        }
    }

    public void removeSortInfo(String key) {
        this.sortInfos.remove(key);
    }

    private String createSortingId() {
        UUID uuid = UUID.randomUUID();
        String timeInfo = String.valueOf(System.currentTimeMillis());
        return uuid + "-" + timeInfo;
    }

    public void restore(SortInfo sortInfo) {
        log.debug("[RestoreData] Restore packet off again. [Barcode:" + sortInfo.getBarcode() + "]");
        this.packetOffInfoService.saveBySortInfo(sortInfo);
    }

    public void offerSortInfoDataToQueue(SortInfo sortInfo) {
        if (sortInfo == null) {
            return;
        }
        this.failedQueue.offer(sortInfo);
    }

    public void requestSortInfo(SortInfo sortInfo) {
        log.info("carId : [" + sortInfo.getCarId() + "] barcode : [" + sortInfo.getBarcode() + "]");
        log.info("\u8bf7\u6c42\u683c\u53e3\u4fe1\u606f\uff0c\u6761\u7801\uff1a" + sortInfo.getBarcode());
        this.doSetUploadFlag(sortInfo);
        RC res = CommandExecutor.executorCommand((String)WebSortInfoCmd.NAME, (Object)sortInfo, (boolean)true);
        if (!res.success) {
            log.error("[WebSortInfoError] billCode : [" + sortInfo.getBarcode() + "] errorCode : [" + sortInfo.getErrorCodeSVR() + "]");
        }
    }

    public void doSetUploadFlag(SortInfo sortInfo) {
        if (this.sortConfig.isRepeatUpload()) {
            return;
        }
        List sortInfos = this.packetOffInfoService.listPacketByBarcode(sortInfo.getBarcode());
        if (CollectionUtil.isNotEmpty((Collection)sortInfos)) {
            this.expiredTask.offerPacketExpiredToQueue(sortInfo);
            for (TtPacketOffInfo info : sortInfos) {
                if (info.getErrorCodePlc() != 0) continue;
                if (StrUtil.isBlank((CharSequence)info.getBoxCode()) || info.getBoxCode().equals("none")) {
                    sortInfo.setUploadFlag(-3);
                    continue;
                }
                sortInfo.setUploadFlag(-2);
                break;
            }
        }
    }

    public void doSetNoUploadByErrorCode(SortInfo sortInfo, List<String> ruleList) {
        if (sortInfo.getUploadFlag() == -2) {
            return;
        }
        if (CollectionUtil.isEmpty(ruleList)) {
            return;
        }
        for (String ruleStr : ruleList) {
            double uploadRate;
            String errorCode;
            if (ruleStr.contains(":")) {
                String[] rules = ruleStr.split(":");
                errorCode = rules[0];
                uploadRate = Double.parseDouble(rules[1]);
            } else {
                errorCode = ruleStr;
                uploadRate = 1.0;
            }
            if (!errorCode.equals(String.valueOf(sortInfo.getErrorCodePLC()))) continue;
            if (!((double)RandomUtil.randomInt((int)100) < uploadRate * 100.0)) break;
            sortInfo.setUploadFlag(-2);
            break;
        }
    }

    private void createSiteCodeValue(SortInfo sortInfo) {
        int roadSlotValue;
        List slots = sortInfo.getSlotsList();
        Collections.sort(slots);
        String roadSlot = StrUtil.join((CharSequence)"", (Object[])slots.toArray());
        if (roadSlot == null || roadSlot.isEmpty()) {
            return;
        }
        if (this.roadSlots.containsKey(roadSlot)) {
            roadSlotValue = (Integer)this.roadSlots.get(roadSlot);
        } else {
            roadSlotValue = this.roadSlotSerial.incrementAndGet();
            this.roadSlots.put(roadSlot, roadSlotValue);
        }
        sortInfo.setRoadSlotValue(roadSlotValue);
    }

    private SortInfoService() {
    }

    public ConcurrentHashMap<String, SortInfo> getSortInfos() {
        return this.sortInfos;
    }

    public BlockingQueue<SortInfo> getFailedQueue() {
        return this.failedQueue;
    }
}

