/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScreenService {
    private static final Logger log = LoggerFactory.getLogger(ScreenService.class);
    private Channel slotScreen;
    private Channel bigScreen;
    @Resource
    private SlotService slotService;

    private Map<String, Object> createSlotScreenInfo(SlotInfo info) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("ServiceName", "screenSlot");
        responseMap.put("slot", info.getSlotId());
        responseMap.put("route", info.getArriveCode());
        responseMap.put("direction", info.getSlotName());
        responseMap.put("currentCount", info.getCurrentMailCount());
        responseMap.put("totalCount", info.getTotalMailCount());
        return responseMap;
    }

    private Map<String, Object> createBigScreenInfo(String slotId, String slotName, int mailCount, boolean isLock) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        if (isLock) {
            responseMap.put("ServiceName", "SlotLock");
            responseMap.put("des", slotName);
            responseMap.put("mailCount", mailCount);
        } else {
            responseMap.put("ServiceName", "SlotUnLock");
        }
        responseMap.put("slot", slotId);
        return responseMap;
    }

    public void sendInfoToSlotScreen(String slotId) {
        if (this.slotScreen == null) {
            log.error("Send slot info to slot screen failure: unregistered");
            return;
        }
        if (!this.slotScreen.isConnected()) {
            log.error("Send slot info to slot screen failure: not connected");
            return;
        }
        if (StrUtil.isEmpty((CharSequence)slotId)) {
            for (SlotInfo info : this.slotService.getSlotInfoList()) {
                ResponseTools.commitResponse((Channel)this.slotScreen, (Map)this.createSlotScreenInfo(info), (boolean)false);
            }
        } else {
            SlotInfo info = this.slotService.getSlotInfo(slotId);
            if (info != null) {
                ResponseTools.commitResponse((Channel)this.slotScreen, (Map)this.createSlotScreenInfo(info), (boolean)false);
            }
        }
    }

    public void sendInfoToBigScreen(String slotId, int mailCount, boolean isLock) {
        if (this.bigScreen == null) {
            log.error("Send slot pack info to big screen failure: unregistered");
            return;
        }
        if (!this.bigScreen.isConnected()) {
            log.error("Send slot pack info to big screen failure: not connected");
            return;
        }
        if (StrUtil.isEmpty((CharSequence)slotId)) {
            log.error("Send slot pack info to big screen failure: slot id can't be null");
            return;
        }
        SlotInfo info = this.slotService.getSlotInfo(slotId);
        if (info != null) {
            ResponseTools.commitResponse((Channel)this.bigScreen, (Map)this.createBigScreenInfo(slotId, info.getSlotName(), mailCount, isLock), (boolean)false);
        }
    }

    private ScreenService() {
    }

    public void setSlotScreen(Channel slotScreen) {
        this.slotScreen = slotScreen;
    }

    public void setBigScreen(Channel bigScreen) {
        this.bigScreen = bigScreen;
    }
}

