/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import com.simba.services.beans.KeepAliveInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChannelsService {
    private static final Logger log = LoggerFactory.getLogger(ChannelsService.class);
    private final ConcurrentHashMap<String, KeepAliveInfo> channels = new ConcurrentHashMap();

    public void updateClient(Channel channel) {
        if (!this.containsClient(channel)) {
            this.addClient(channel);
        } else {
            this.updateClientTime(channel);
        }
    }

    public void addClient(Channel channel) {
        long now = System.currentTimeMillis();
        String key = String.valueOf(channel.getId().shortValue());
        this.channels.put(key, new KeepAliveInfo(channel, now));
    }

    public void updateClientTime(Channel channel) {
        String key = String.valueOf(channel.getId().shortValue());
        if (this.channels.containsKey(key)) {
            KeepAliveInfo info = (KeepAliveInfo)this.channels.get(key);
            if (info != null) {
                long now = System.currentTimeMillis();
                info.setKeepAliveTime(now);
            } else {
                this.addClient(channel);
            }
        } else {
            this.addClient(channel);
        }
    }

    public boolean containsClient(Channel channel) {
        return this.channels.containsKey(String.valueOf(channel.getId().shortValue()));
    }

    public void handlerOverTimeLink() {
        this.handlerClientOverTimeLink();
    }

    private void handlerClientOverTimeLink() {
        try {
            for (Map.Entry entry : this.channels.entrySet()) {
                KeepAliveInfo keepAliveInfo = (KeepAliveInfo)entry.getValue();
                long recordTime = keepAliveInfo.getKeepAliveTime();
                long currentTime = System.currentTimeMillis();
                long spanTime = currentTime - recordTime;
                if (spanTime <= 10000L) continue;
                keepAliveInfo.getChannel().disconnect();
                this.channels.remove(entry.getKey());
            }
        }
        catch (Exception e) {
            log.error("[ChannelsManager.handlerClientOverTimeLink] Catch exception : " + e.getMessage());
        }
    }

    private ChannelsService() {
    }
}

