/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.common.util.TimeUtil;
import com.simba.controllers.SlotPackController;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class SlotPackJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(SlotPackJsonService.class);
    private final SlotService slotService;
    private final SlotPackController slotPackController;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "SlotPack";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            Map request = (Map)content;
            String physicalSlotId = request.get("slotId").toString();
            SlotInfo slotInfo = this.slotService.getSlotInfo(physicalSlotId);
            if (slotInfo != null) {
                slotInfo.setSlotType("1");
                this.slotPackController.onSlotPackMessage(slotInfo);
            }
            log.debug("Slot Pack Json Service request name : " + TimeUtil.createCurrentTimeStamp());
        }
        catch (Exception ex) {
            log.error("Slot Pack Json Service Error : " + ex.getMessage());
        }
    }

    public SlotPackJsonService(SlotService slotService, SlotPackController slotPackController) {
        this.slotService = slotService;
        this.slotPackController = slotPackController;
    }
}

