/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.SortInfo;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class QueryBarcodeJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(QueryBarcodeJsonService.class);
    private final SortInfoService sortInfoService;

    public String getName() {
        return "InfoBarcode";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Channel channel, Object content, String routeKey) {
        block6: {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(routeKey, this.getName());
            try {
                Map request = (Map)content;
                String barcode = request.get("barcode").toString();
                map.put("barcode", barcode);
                map.put("flag", false);
                map.put("count", this.sortInfoService.getSortInfos().size());
                if (StrUtil.isBlank((CharSequence)barcode)) break block6;
                for (SortInfo info : this.sortInfoService.getSortInfos().values()) {
                    if (info == null || !barcode.equals(info.getBarcode())) continue;
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("barcode", info.getBarcode());
                    item.put("slotsList", info.getSlotsList());
                    item.put("roadSlotName", info.getRoadSlotName());
                    item.put("errorCodeSvr", info.getErrorCodeSVR());
                    item.put("errorCodePlc", info.getErrorCodePLC());
                    item.put("droppedSlot", info.getDroppedSlotId());
                    item.put("carId", info.getCarId());
                    item.put("platId", info.getSorterId());
                    map.put("data", item);
                    map.put("flag", true);
                    break;
                }
            }
            catch (Exception e) {
                log.error("Info Barcode Json Service Error " + e.getMessage());
            }
            finally {
                this.renderJson(channel, map);
            }
        }
    }

    public QueryBarcodeJsonService(SortInfoService sortInfoService) {
        this.sortInfoService = sortInfoService;
    }
}

