/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.controllers.PlatScanController;
import com.simba.services.SorterService;
import com.simba.services.beans.PacketScanInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import com.simba.wbapi.udp.SorterMonitorSystem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class PlatScanJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(PlatScanJsonService.class);
    private final SorterService sorterService;
    private final PlatScanController platScanController;
    private final RedisTemplate redisTemplate;
    private final SorterMonitorSystem sorterMonitorSystem;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "PlatScanned";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        String barcode = "";
        try {
            long startTime = System.currentTimeMillis();
            Map request = (Map)content;
            barcode = request.get("barcode").toString();
            if (StrUtil.isBlank((CharSequence)barcode)) {
                return;
            }
            String workerNo = request.get("workerNumber").toString();
            String platId = request.get("platId").toString();
            String weight = request.get("weight").toString();
            String uuid = request.get("uuid").toString();
            String length = "0";
            String width = "0";
            String height = "0";
            String volume = request.get("volume").toString();
            Object platRds = this.redisTemplate.opsForValue().get((Object)("platIdUser:" + workerNo));
            SorterInfo plat = this.sorterService.getSorterById(platId);
            if (plat == null) {
                this.renderJson(channel, this.createResponse("\u9519\u8bef", "", "0", barcode, -1, "SmPlatNotFindError", null));
                return;
            }
            if (null == plat.getSorterId()) {
                this.renderJson(channel, this.createResponse("\u9519\u8bef", "", "0", barcode, -1, "SmPlatConfigError", null));
                return;
            }
            platId = plat.getSorterId();
            log.info("get sortId {} success by clientSortId {}", (Object)plat.getClientSorterId(), (Object)plat.getSorterId());
            plat.setChannel(channel);
            if (request.containsKey("mailType")) {
                plat.setMailType(request.getOrDefault("mailType", "").toString());
            }
            SortInfo sortInfo = this.sorterService.handleScannedCommand(PacketScanInfo.builder().sorterId(platId).sorterMode("0").barcode(barcode).plcId("PLAT-SCANNED").scanMode("PLAT").scanType("AUTO").complementType("autoScan").workerNo(workerNo).scanTime(new Date()).length(length).width(width).height(height).imgUuid(uuid).volume(volume).weight(weight).build());
            this.platScanController.onPlatScanMessage(sortInfo);
            if (sortInfo == null) {
                this.renderJson(channel, this.createResponse("\u9519\u8bef", "", "0", barcode, -1, "SmDataParseError", null));
                return;
            }
            String slotsContent = StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getSlotsList()});
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            BigDecimal bigDecimal = BigDecimal.valueOf(time).divide(new BigDecimal(1000)).setScale(2, RoundingMode.CEILING);
            if (sortInfo.getErrorCodeSVR() == 10) {
                log.info("Request sort info error 10: barcode {}", (Object)barcode);
                this.renderJson(channel, this.createResponse("\u0410\u043d\u043e\u043c\u0430\u043b\u0438\u044f:" + barcode, "\u0410\u043d\u043e\u043c\u0430\u043b\u0438\u044f: " + barcode, "0", barcode, -1, "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 \n \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e", Double.valueOf(bigDecimal.doubleValue())));
                plat.resetSelf();
                return;
            }
            this.renderJson(channel, this.createResponse(sortInfo.getRoadSlotName(), slotsContent, "0", barcode, sortInfo.getErrorCodeSVR(), "SmSuccess", Double.valueOf(bigDecimal.doubleValue())));
            try {
                this.sorterMonitorSystem.sendBarCodeToSap(barcode, String.valueOf(request.get("platId")), Integer.valueOf(1));
            }
            catch (Exception e) {
                log.error("sendBarCodeToSap error: " + e.getMessage());
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            this.renderJson(channel, this.createResponse("\u9519\u8bef", "", "0", barcode, -1, "SmServiceError", null));
            log.error("Plat sort json service error " + ex.getMessage());
        }
    }

    public static void main(String[] args) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        Thread.sleep(1234L);
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        BigDecimal bigDecimal = BigDecimal.valueOf(time).divide(new BigDecimal(1000)).setScale(2, RoundingMode.CEILING);
        System.out.println(bigDecimal);
    }

    private Map<String, Object> createResponse(String sortModel, String factualSlot, String isNeedVideo, String barcode, int errorCode, String msg, Double countVal) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("ServiceName", "SortResult");
        response.put("sortModel", sortModel);
        response.put("factualSlot", factualSlot);
        response.put("isNeedVideo", isNeedVideo);
        response.put("barcode", barcode);
        response.put("exceptionCode", errorCode);
        response.put("msg", msg);
        response.put("des", countVal + "s");
        return response;
    }

    public PlatScanJsonService(SorterService sorterService, PlatScanController platScanController, RedisTemplate redisTemplate, SorterMonitorSystem sorterMonitorSystem) {
        this.sorterService = sorterService;
        this.platScanController = platScanController;
        this.redisTemplate = redisTemplate;
        this.sorterMonitorSystem = sorterMonitorSystem;
    }
}

