/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.net.NetTools;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SorterService;
import com.simba.services.beans.SorterInfo;
import com.simba.services.msg.FrameMsgService;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class PlatResetJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(PlatResetJsonService.class);
    public static final String NAME = PlatResetJsonService.class.getName();
    private final SorterService sorterService;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "ResetPlat";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            Map request = (Map)content;
            String platId = request.get("platId").toString();
            SorterInfo plat = this.sorterService.getSorterById(platId);
            if (plat == null) {
                return;
            }
            plat.resetSelf();
            int platIdValue = Integer.parseInt(plat.getSorterId());
            byte[] sendContent = FrameMsgService.createResetPlatBuffer((int)platIdValue);
            NetTools.getFrameServer().getClients().values().forEach(client -> client.sendByteContent(sendContent));
        }
        catch (Exception e) {
            log.error("Dummy json service error : exception info : " + e.getMessage());
        }
    }

    public PlatResetJsonService(SorterService sorterService) {
        this.sorterService = sorterService;
    }
}

