/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SorterService;
import com.simba.services.params.SortConfig;
import com.simba.wbapi.ApiClientExample;
import com.simba.wbapi.RequestEntities;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class PlatLoginOutService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(PlatLoginOutService.class);
    private final SorterService sorterService;
    private final SortConfig sortConfig;
    private final ApiClientExample apiClientExample;
    private final RedisTemplate redisTemplate;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "Logout";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, String> responseMap;
        block6: {
            responseMap = new HashMap<String, String>();
            responseMap.put(routeKey, "AckLogin");
            try {
                Map request = (Map)content;
                String username = request.get("UserName").toString();
                String platID = request.get("platID").toString();
                responseMap.put("username", username);
                if (StringUtils.isEmpty((CharSequence)username)) {
                    responseMap.put("Result", "username or password can't be null");
                    break block6;
                }
                try {
                    RequestEntities.LogoutRequest requestParams = new RequestEntities.LogoutRequest();
                    requestParams.setEmployee_id(Integer.parseInt(username));
                    requestParams.setSort_place_id(this.sortConfig.getSortPlaceId());
                    requestParams.setIn_feed_place_id(Integer.parseInt(platID));
                    String logout = this.apiClientExample.logout(requestParams);
                    this.redisTemplate.opsForValue().set((Object)("platIdUser:" + username), null);
                }
                catch (Exception e) {
                    responseMap.put("Result", "Error");
                    log.info("logout error {}", (Object)e.getMessage());
                }
                if (!this.sortConfig.isLoginOnSap()) {
                    responseMap.put("Result", "success");
                }
            }
            catch (Exception ex) {
                responseMap.put("Result", "error:" + ex.getMessage());
                log.error("Login json service error " + ex.getMessage());
            }
        }
        this.renderJson(channel, responseMap);
    }

    public PlatLoginOutService(SorterService sorterService, SortConfig sortConfig, ApiClientExample apiClientExample, RedisTemplate redisTemplate) {
        this.sorterService = sorterService;
        this.sortConfig = sortConfig;
        this.apiClientExample = apiClientExample;
        this.redisTemplate = redisTemplate;
    }
}

