/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.SorterService;
import com.simba.services.beans.SorterInfo;
import com.simba.services.params.MachineParams;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class MesHeartBeatJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(MesHeartBeatJsonService.class);
    private final SorterService sorterService;
    private final MachineParams machineParams;

    public String getName() {
        return "MesHeartBeat";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            Map request = (Map)content;
            String platId = request.get("platId").toString();
            if (StrUtil.isBlank((CharSequence)platId)) {
                return;
            }
            SorterInfo sorter = this.sorterService.getSorterById(platId);
            if (sorter == null) {
                return;
            }
            int platMode = sorter.getSorterModel();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("ServiceName", "ToMes");
            response.put("type", "heartbeat");
            response.put("platMode", platMode);
            response.put("status", this.machineParams.getRunStatus());
            this.renderJson(channel, response);
        }
        catch (Exception e) {
            log.error("Mes Heart Beat Service Error : exception info : " + e.getMessage());
        }
    }

    public MesHeartBeatJsonService(SorterService sorterService, MachineParams machineParams) {
        this.sorterService = sorterService;
        this.machineParams = machineParams;
    }
}

