/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.params.MachineParams;
import java.util.HashMap;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class BusyStatusJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(BusyStatusJsonService.class);
    private final MachineParams machineParams;

    public String getName() {
        return "BusyStatus";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put(routeKey, this.getName());
        try {
            long lastPacketOffTime = this.machineParams.getLastPacketOffTime();
            long freeTime = 180000L;
            long between = System.currentTimeMillis() - lastPacketOffTime;
            if (between >= freeTime) {
                responseMap.put("Result", "free");
            } else {
                responseMap.put("Result", "busy");
            }
        }
        catch (Exception e) {
            log.error("Busy Status Service Error : exception info : " + e.getMessage());
        }
        this.renderJson(channel, responseMap);
    }

    public BusyStatusJsonService(MachineParams machineParams) {
        this.machineParams = machineParams;
    }
}

