/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.common.util.TimeUtil;
import com.simba.controllers.SlotPackController;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class AllSlotPackJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(AllSlotPackJsonService.class);
    private final SlotService slotService;
    private final SlotPackController slotPackController;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "SlotsPack";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            for (SlotInfo slotInfo : this.slotService.getSlotInfoList()) {
                slotInfo.setSlotType("1");
                this.slotPackController.onSlotPackMessage(slotInfo);
            }
            log.debug("Slots Pack Json Service request name : " + TimeUtil.createCurrentTimeStamp());
        }
        catch (Exception ex) {
            log.error("SlotsPack Json Service Error : " + ex.getMessage());
        }
    }

    public AllSlotPackJsonService(SlotService slotService, SlotPackController slotPackController) {
        this.slotService = slotService;
        this.slotPackController = slotPackController;
    }
}

