/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.controllers.SlotPackController;
import com.simba.controllers.SlotUnlockController;
import com.simba.services.ChannelsService;
import com.simba.services.SlotService;
import com.simba.services.SorterService;
import com.simba.services.beans.SlotInfo;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class SlotPackDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(SlotPackDecoder.class);
    private final SlotPackController slotPackController;
    private final SlotUnlockController slotUnlockController;
    private final SlotService slotService;
    private final ChannelsService channelsService;
    private final SorterService sorterService;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 9;
    }

    public void doDecode(Channel channel, byte[] content) {
        try {
            int slotIdValue = FrameUtil.getUnsignedShortBigEndian((int)3, (byte[])content);
            String slotKey = String.valueOf(slotIdValue);
            SlotInfo slotInfo = this.slotService.getSlotInfo(slotKey);
            if (slotInfo == null) {
                log.error("[SlotPackDecoder] Slot not found! Slot ID:" + slotKey);
                return;
            }
            slotInfo.setSlotType("3");
            this.slotPackController.onSlotPackMessage(slotInfo);
            content[0] = 2;
            content[1] = 1;
            ResponseTools.commitResponse((Channel)channel, (byte[])content, (boolean)false);
        }
        catch (Exception ex) {
            log.error("Slot Pack Error -- Exception : " + ex.getMessage());
        }
    }

    public SlotPackDecoder(SlotPackController slotPackController, SlotUnlockController slotUnlockController, SlotService slotService, ChannelsService channelsService, SorterService sorterService) {
        this.slotPackController = slotPackController;
        this.slotUnlockController = slotUnlockController;
        this.slotService = slotService;
        this.channelsService = channelsService;
        this.sorterService = sorterService;
    }
}

