/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.services.SorterService;
import com.simba.services.beans.SorterInfo;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class PlatStatusDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(PlatStatusDecoder.class);
    private final SorterService sorterService;

    public byte getName() {
        return 21;
    }

    public void doDecode(Channel channel, byte[] message) {
        try {
            String platId = String.valueOf(message[3]);
            byte platMode = message[4];
            byte platStatus = message[5];
            SorterInfo plat = this.sorterService.getSorterById(platId);
            if (plat != null) {
                plat.setSorterModel((int)platMode);
                plat.setSorterStatus((int)platStatus);
            }
        }
        catch (Exception ex) {
            log.error("Plat scanned decode catch exception : " + ex.getMessage());
        }
    }

    public PlatStatusDecoder(SorterService sorterService) {
        this.sorterService = sorterService;
    }
}

