/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.controllers.PlatScanController;
import com.simba.services.SorterService;
import com.simba.services.beans.PacketScanInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class PlatScanDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(PlatScanDecoder.class);
    private final SorterService sorterService;
    private final PlatScanController platScanController;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 5;
    }

    public void doDecode(Channel channel, byte[] message) {
        try {
            int position = 3;
            byte platIdBinary = message[position];
            String platId = String.valueOf(platIdBinary);
            byte modeBinary = message[++position];
            String mode = String.valueOf(modeBinary);
            byte barcodeLen = message[++position];
            String barcode = new String(message, ++position, (int)barcodeLen, StandardCharsets.UTF_8);
            byte plcIdLen = message[position += barcodeLen];
            String plcId = new String(message, ++position, (int)plcIdLen, StandardCharsets.UTF_8);
            SorterInfo plat = this.sorterService.getSorterById(platId);
            if (plat != null) {
                SortInfo info = this.sorterService.handleScannedCommand(PacketScanInfo.builder().sorterId(platId).sorterMode(mode).barcode(barcode).plcId(plcId).scanMode("PLC").scanType("AUTO").workerNo("plat").scanTime(new Date()).build());
                this.platScanController.onPlatScanMessage(info);
            }
        }
        catch (Exception ex) {
            log.error("Plat scanned decode catch exception : " + ex.getMessage());
        }
    }

    public PlatScanDecoder(SorterService sorterService, PlatScanController platScanController) {
        this.sorterService = sorterService;
        this.platScanController = platScanController;
    }
}

