/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.controllers.PacketOnController;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.PacketOnInfo;
import com.simba.services.beans.SorterInfo;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Date;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class PacketOnDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(PacketOnDecoder.class);
    private final PacketOnController packetOnController;
    private final SorterService sorterService;
    private final SortInfoService sortInfoService;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 3;
    }

    public void doDecode(Channel channel, byte[] content) {
        try {
            int position = 3;
            int carIdValue = FrameUtil.getUnsignedShortBigEndian((int)position, (byte[])content);
            String carId = String.valueOf(carIdValue);
            byte platIdBinary = content[position += 2];
            String platId = String.valueOf(platIdBinary);
            byte modeBinary = content[++position];
            String mode = String.valueOf(modeBinary);
            byte barcodeLen = content[++position];
            ++position;
            String barcode = "NoRead";
            if (barcodeLen != 0) {
                barcode = new String(content, position, (int)barcodeLen, StandardCharsets.UTF_8);
                position += barcodeLen;
            }
            byte plcIdLen = content[position];
            String plcId = new String(content, ++position, (int)plcIdLen, StandardCharsets.UTF_8);
            int weightValue = FrameUtil.getUnsignedShortBigEndian((int)(position += plcIdLen), (byte[])content);
            SorterInfo sorterInfo = this.sorterService.getSorterById(platId);
            log.info("PacketOnDecoder sorterInfo :carId:" + carId + "platId:" + platId + "mode:" + mode + "barcode:" + barcode);
            if (sorterInfo == null) {
                log.error("[PacketOnDecoder] Sorter not found! Sorter ID:" + platId);
                return;
            }
            DecimalFormat df = new DecimalFormat("#0.00");
            String weight = df.format((double)weightValue * sorterInfo.getWeightRatio());
            this.packetOnController.onPacketOnMessage(PacketOnInfo.builder().carId(carId).sorterId(platId).sorterMode(mode).workerNo("plc").plcId(plcId).barcode(barcode).weight(weight).packetOnTime(new Date()).build());
            content[0] = 2;
            content[1] = 1;
            ResponseTools.commitResponse((Channel)channel, (byte[])content, (boolean)false);
        }
        catch (Exception ex) {
            log.error("PacketOn decoder error : exception info : " + ex.getMessage());
        }
    }

    public PacketOnDecoder(PacketOnController packetOnController, SorterService sorterService, SortInfoService sortInfoService) {
        this.packetOnController = packetOnController;
        this.sorterService = sorterService;
        this.sortInfoService = sortInfoService;
    }
}

