/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.frame;

import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.common.socket.framework.annotation.NetDecoder;
import com.simba.common.socket.framework.base.decoder.BaseDecoder;
import com.simba.controllers.ObrScanController;
import com.simba.services.BarcodeService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.MachineParams;
import java.nio.charset.StandardCharsets;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetDecoder(managerNames={"frameByteServiceManager"})
public class ObrScanDecoder
extends BaseDecoder {
    private static final Logger log = LoggerFactory.getLogger(ObrScanDecoder.class);
    private final SortInfoService sortInfoService;
    private final BarcodeService barcodeService;
    private final MachineParams machineParams;
    private final ObrScanController obrScanController;

    public boolean isLog() {
        return true;
    }

    public byte getName() {
        return 6;
    }

    public void doDecode(Channel channel, byte[] content) {
        try {
            String weight;
            String volume;
            String height;
            String width;
            String length;
            int position = 3;
            int carIdInt = FrameUtil.getUnsignedShortBigEndian((int)position, (byte[])content);
            String carIdStr = String.valueOf(carIdInt);
            log.info("OBR \u626b\u63cf\u8bf7\u6c42\u63a5\u53e3 carId:{}", (Object)carIdStr);
            byte carStatus = content[position += 2];
            ++position;
            if (carStatus != 1) {
                log.info("carId:{} \u8f66\u8f86\u72b6\u6001\u5f02\u5e38", (Object)(carIdInt + "carStatus:" + carStatus));
                return;
            }
            byte triggerStatus = content[position];
            ++position;
            if (triggerStatus != 1) {
                log.info("carId:{} \u89e6\u53d1\u5668\u72b6\u6001\u5f02\u5e38", (Object)(carIdInt + "triggerStatus:" + triggerStatus));
                return;
            }
            SortInfo sortInfo = this.sortInfoService.createSortInfo();
            sortInfo.setCarId(carIdStr);
            byte obr = content[position];
            ++position;
            if (obr != 1 && obr != 2) {
                obr = 1;
            }
            sortInfo.setObr((int)obr);
            int barcodeNumber = content[position];
            ++position;
            String invalidBarcode = "InvalidCode";
            for (int i = 0; i < barcodeNumber; ++i) {
                byte barcodeLen;
                String barcode;
                if (this.barcodeService.checkBarcodeValid(barcode = new String(content, ++position, (int)(barcodeLen = content[position]), StandardCharsets.UTF_8))) {
                    sortInfo.setBarcode(barcode);
                    sortInfo.getBarcodeList().add(barcode);
                } else {
                    invalidBarcode = barcode;
                }
                position += barcodeLen;
            }
            byte plcIdLen = content[position];
            byte[] plcIdBuffer = new byte[plcIdLen];
            System.arraycopy(content, ++position, plcIdBuffer, 0, plcIdLen);
            position += plcIdLen;
            String plcId = "NoDefine";
            try {
                plcId = new String(plcIdBuffer, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                plcId = "0000000000";
            }
            sortInfo.setPlcId(plcId);
            byte turnNumber = content[position];
            ++position;
            sortInfo.setTurnNumber((int)turnNumber);
            log.info("carId:{};\u5708\u6570\uff1a{}", (Object)carIdStr, (Object)(turnNumber + "barcode:" + sortInfo.getBarcodeList().toString() + "plcId:" + plcId + "obr:" + obr + "barcodeNumber:" + barcodeNumber + "barcode:" + sortInfo.getBarcode() + "plcId:" + plcId + "turnNumber:" + turnNumber + "sorterId:" + sortInfo.getSorterId() + "length:" + sortInfo.getLength() + "width:" + sortInfo.getWidth() + "height:" + sortInfo.getHeight() + "volume:" + sortInfo.getVolume() + "weight:" + sortInfo.getWeight()));
            if (turnNumber > this.machineParams.getMaxLoopCircles()) {
                sortInfo.setErrorCodeSVR(5);
            }
            byte platId = content[position];
            ++position;
            sortInfo.setSorterId(String.valueOf(platId));
            if (sortInfo.getBarcodeList().isEmpty()) {
                if (!invalidBarcode.equals("InvalidCode")) {
                    sortInfo.setBarcode(invalidBarcode);
                    sortInfo.setErrorCodeSVR(7);
                } else {
                    sortInfo.setBarcode("NoRead");
                    sortInfo.getBarcodeList().add("NoRead");
                    sortInfo.setErrorCodeSVR(3);
                }
            } else if (!this.barcodeService.checkBarcodeListValid(sortInfo)) {
                // empty if block
            }
            byte[] lengthBuffer = new byte[4];
            System.arraycopy(content, position, lengthBuffer, 0, 4);
            position += 4;
            try {
                length = new String(lengthBuffer, StandardCharsets.UTF_8);
                length = String.valueOf(Double.parseDouble(length) / 10.0);
            }
            catch (Exception e) {
                length = "0";
            }
            byte[] widthBuffer = new byte[4];
            System.arraycopy(content, position, widthBuffer, 0, 4);
            position += 4;
            try {
                width = new String(widthBuffer, StandardCharsets.UTF_8);
                width = String.valueOf(Double.parseDouble(width) / 10.0);
            }
            catch (Exception e) {
                width = "0";
            }
            byte[] heightBuffer = new byte[4];
            System.arraycopy(content, position, heightBuffer, 0, 4);
            position += 4;
            try {
                height = new String(heightBuffer, StandardCharsets.UTF_8);
                height = String.valueOf(Double.parseDouble(height) / 10.0);
            }
            catch (Exception e) {
                height = "0";
            }
            byte[] volumeBuffer = new byte[8];
            System.arraycopy(content, position, volumeBuffer, 0, 8);
            position += 8;
            try {
                volume = new String(volumeBuffer, StandardCharsets.UTF_8);
                volume = String.valueOf(Double.parseDouble(volume));
            }
            catch (Exception e) {
                volume = "0";
            }
            byte[] weightBuffer = new byte[4];
            System.arraycopy(content, position, weightBuffer, 0, 4);
            position += 4;
            try {
                weight = new String(weightBuffer, StandardCharsets.UTF_8);
                weight = String.valueOf(Double.parseDouble(weight) / 10.0);
            }
            catch (Exception e) {
                weight = "0";
            }
            sortInfo.setLength(length);
            sortInfo.setWidth(width);
            sortInfo.setHeight(height);
            sortInfo.setVolume(volume);
            sortInfo.setWeight(weight);
            log.info("carId:{},{}", (Object)carIdStr, (Object)(length + "\u5bbd\uff1a" + width + "\u9ad8\uff1a" + height + "\u4f53\u79ef\uff1a" + volume + "\u91cd\u91cf\uff1a" + weight + "carId:" + sortInfo.getCarId() + "obr:" + sortInfo.getObr() + "barcode:" + sortInfo.getBarcode() + "plcId:" + sortInfo.getPlcId() + "turnNumber:" + sortInfo.getTurnNumber()));
            this.obrScanController.onSortInfoMessage(sortInfo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("[SortInfoDecoder.doDecode] Do decode sort info error : " + ex + "]");
        }
    }

    public ObrScanDecoder(SortInfoService sortInfoService, BarcodeService barcodeService, MachineParams machineParams, ObrScanController obrScanController) {
        this.sortInfoService = sortInfoService;
        this.barcodeService = barcodeService;
        this.machineParams = machineParams;
        this.obrScanController = obrScanController;
    }
}

