/*
 * Decompiled with CFR 0.152.
 */
package com.simba.databases.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.common.data.DateDTO;
import com.simba.common.data.ParamDTO;
import com.simba.common.time.RecordTime;
import com.simba.common.util.CommonUtil;
import com.simba.common.util.TimeUtil;
import com.simba.databases.entity.TtPacketOffInfoReport;
import com.simba.databases.mapper.TtPacketOffInfoReportMapper;
import com.simba.databases.mapper.TtTrashTypeMapper;
import com.simba.databases.service.ITtPacketOffInfoReportService;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.SortConfig;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class TtPacketOffInfoReportServiceImpl
extends ServiceImpl<TtPacketOffInfoReportMapper, TtPacketOffInfoReport>
implements ITtPacketOffInfoReportService {
    private final TtTrashTypeMapper trashTypeMapper;
    private final SortConfig sortConfig;

    public boolean deleteRecord(Timestamp recordTime) {
        return this.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().le(TtPacketOffInfoReport::getRecordTime, (Object)recordTime)).last("limit 10000"));
    }

    @RecordTime
    public boolean saveBySortInfo(SortInfo sortInfo) {
        return this.save((Object)TtPacketOffInfoReport.builder().barcode(CommonUtil.doNullData((String)sortInfo.getBarcode(), (String)"none")).sorterId(CommonUtil.doNullData((String)sortInfo.getSorterId(), (String)"none")).serverSlots(CommonUtil.doNullData((String)StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getSlotsList()}), (String)"none")).droppedSlot(Integer.valueOf(sortInfo.getDroppedSlotId())).boxCode(CommonUtil.doNullData((String)sortInfo.getBoxCode(), (String)"none")).obrNo(Integer.valueOf(sortInfo.getObr())).errorCodeSvr(Integer.valueOf(sortInfo.getErrorCodeSVR())).errorCodePlc(Integer.valueOf(sortInfo.getErrorCodePLC())).scannedTime(sortInfo.getPacketOnTime()).packetOffTime(sortInfo.getPacketOffTime()).roadSlot(CommonUtil.doNullData((String)sortInfo.getRoadSlot(), (String)"none")).roadSlotName(CommonUtil.doNullData((String)sortInfo.getRoadSlotName(), (String)"none")).expiredFlag(Integer.valueOf(0)).recordTime(new Date()).area(CommonUtil.doNullData((String)this.sortConfig.getArea(), (String)"0")).imgUuid(sortInfo.getImgUuid()).build());
    }

    public boolean updateBarcodeInfoExpired(String barcode) {
        return this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(TtPacketOffInfoReport::getExpiredFlag, (Object)1)).eq(TtPacketOffInfoReport::getBarcode, (Object)barcode));
    }

    public List<Map<String, Object>> formBySlotPackCount(Map<String, ParamDTO> maps) {
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formBySlotPackCount((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formBySlotCount(Map<String, ParamDTO> maps) {
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formBySlotCount((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formByPlat(Map<String, ParamDTO> maps) {
        QueryWrapper wrapper = this.getQueryWrapperFromParams(maps);
        StringBuilder columns = new StringBuilder();
        columns.append("(case sorter_id when sorter_id then sorter_id ELSE '\u5408\u8ba1' END ) AS platId,");
        columns.append("count( CASE WHEN error_code_plc !='0' THEN '-1' END ) as unusual,");
        columns.append("round( count( CASE WHEN error_code_plc !='3' THEN '-2' END ) * 100 / count( id ), 2) AS readRate,");
        columns.append("round( count( CASE WHEN error_code_plc !='0' THEN '-3' END ) * 100 / count( id ), 2) AS trashRate,");
        List trashList = this.trashTypeMapper.selectList(null);
        if (trashList != null) {
            trashList.forEach(trashType -> columns.append("count( CASE error_code_plc WHEN '").append(trashType.getExceptionCode()).append("' THEN '").append(trashType.getExceptionCode()).append("' END ) AS '").append(trashType.getExceptionDesc()).append("',"));
        }
        columns.append("count( id ) AS total");
        wrapper.select(new String[]{columns.toString()});
        wrapper.groupBy((Object)" sorter_id WITH ROLLUP");
        List result = ((TtPacketOffInfoReportMapper)this.baseMapper).formByPlat((Wrapper)wrapper);
        if (!result.isEmpty()) {
            int hours;
            ParamDTO dto = maps.get("recordTime");
            if (dto == null || dto.getType() != 2 || dto.getValue() == null) {
                result.forEach(item -> item.put("efficiency", "0/h"));
                return result;
            }
            DateDTO dateBean = (DateDTO)CommonUtil.getGson().fromJson(CommonUtil.getGson().toJson(dto.getValue()), new /* Unavailable Anonymous Inner Class!! */.getType());
            if (dateBean == null || dateBean.getBeginDate() == null || dateBean.getEndDate() == null) {
                result.forEach(item -> item.put("efficiency", "0/h"));
                return result;
            }
            try {
                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                Date fromDate2 = simpleFormat.parse(dateBean.getBeginDate());
                Date toDate2 = simpleFormat.parse(dateBean.getEndDate());
                long from2 = fromDate2.getTime();
                long to2 = toDate2.getTime();
                hours = (int)((to2 - from2) / 3600000L);
                int value = (int)((to2 - from2) % 3600000L);
                if (value >= 30) {
                    ++hours;
                }
                if (hours == 0) {
                    hours = 1;
                }
            }
            catch (Exception e) {
                hours = 1000000;
            }
            int finalHours = hours;
            result.forEach(item -> {
                double count = Double.parseDouble(item.get("total").toString());
                double speed = count / (double)finalHours;
                int nspeed = (int)Math.round(speed);
                if (nspeed <= 0) {
                    nspeed = speed == 0.0 ? 0 : 1;
                }
                item.put("efficiency", nspeed + "/\u5c0f\u65f6");
            });
        }
        return result;
    }

    public List<Map<String, Object>> formByLineSlotCount(Map<String, ParamDTO> maps) {
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formByLineSlotCount((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formByReadRate(Map<String, ParamDTO> maps) {
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formByReadRate((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formBySortGeneral(Map<String, ParamDTO> maps) {
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formBySortGeneral((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formByEfficiencyPlat(Map<String, ParamDTO> maps) {
        this.checkDefaultValueForMap(maps);
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formByEfficiencyPlat((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formByGeneralRate(Map<String, ParamDTO> maps) {
        QueryWrapper wrapper = this.getQueryWrapperFromParams(maps);
        wrapper.eq((Object)"expired_flag", (Object)0);
        List result = ((TtPacketOffInfoReportMapper)this.baseMapper).formByGeneralRate((Wrapper)wrapper);
        List trashList = this.trashTypeMapper.selectList(null);
        int count = 0;
        double rate = 0.0;
        HashMap errorCodeList = new HashMap();
        trashList.forEach(item -> errorCodeList.put(item.getExceptionCode().toString(), item.getExceptionDesc()));
        for (Map item2 : result) {
            String errorCode = item2.get("errorCodePLC").toString();
            item2.put("exceptionDesc", errorCodeList.getOrDefault(errorCode, "none"));
            int itemCount = Integer.parseInt(item2.get("count").toString());
            double itemRate = Double.parseDouble(item2.get("percent").toString());
            if (errorCode.equals("0")) continue;
            count += itemCount;
            rate += itemRate;
        }
        HashMap<String, Object> lastItem = new HashMap<String, Object>();
        lastItem.put("errorCodePLC", "\u5f02\u5e38\u603b\u91cf");
        lastItem.put("exceptionDesc", "\u5f02\u5e38\u603b\u91cf");
        lastItem.put("count", count);
        lastItem.put("percent", String.format("%.2f", rate));
        result.add(lastItem);
        return result;
    }

    public List<Map<String, Object>> formByMaxSortTime(Map<String, ParamDTO> maps) {
        String columnSearchTime;
        if (maps == null) {
            maps = new HashMap<String, ParamDTO>();
        }
        int period = 15;
        String columnPeriod = "period";
        if (maps.containsKey(columnPeriod)) {
            period = Integer.parseInt(maps.get(columnPeriod).getValue().toString());
            maps.remove(columnPeriod);
        }
        if (!maps.containsKey(columnSearchTime = "packetOffTime")) {
            SimpleDateFormat formatB = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            SimpleDateFormat formatE = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            maps.put(columnSearchTime, new ParamDTO(2, (Object)new DateDTO(formatB.format(new Date()), formatE.format(new Date()))));
        } else {
            ParamDTO paramBean = maps.get(columnSearchTime);
            if (paramBean.getValue() != null) {
                DateDTO dateBean = (DateDTO)CommonUtil.getGson().fromJson(CommonUtil.getGson().toJson(paramBean.getValue()), new /* Unavailable Anonymous Inner Class!! */.getType());
                paramBean.setValue((Object)dateBean);
            }
        }
        List result = ((TtPacketOffInfoReportMapper)this.baseMapper).formByMaxSortTime((Wrapper)this.getQueryWrapperFromParams(maps));
        if (result == null) {
            return result;
        }
        DateDTO bean = (DateDTO)maps.get(columnSearchTime).getValue();
        long totalMinutes = TimeUtil.getTimeDifference((String)bean.getBeginDate(), (String)bean.getEndDate());
        if (totalMinutes > 1440L) {
            return null;
        }
        try {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date beginTime = format.parse(bean.getBeginDate());
            Calendar calendar = Calendar.getInstance();
            int i = 0;
            while ((long)i < totalMinutes) {
                calendar.setTime(beginTime);
                calendar.add(12, i);
                Date dateBegin = calendar.getTime();
                calendar.add(12, period);
                Date dateEnd = calendar.getTime();
                int num = 0;
                for (Map rowData : result) {
                    Date nowDate = format.parse(rowData.get("secound").toString());
                    if (!nowDate.after(dateBegin) && !nowDate.equals(dateBegin) || !nowDate.before(dateEnd)) continue;
                    num += Integer.parseInt(rowData.get("num").toString());
                }
                HashMap<String, String> dataRow = new HashMap<String, String>();
                dataRow.put("timeBegin", format.format(dateBegin));
                dataRow.put("timeEnd", format.format(dateEnd));
                dataRow.put("barcodeNum", String.valueOf(num));
                data.add(dataRow);
                ++i;
            }
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Map<String, Object>> formByReadRateTime(Map<String, ParamDTO> maps) {
        this.checkDefaultValueForMap(maps);
        QueryWrapper wrapper = this.getQueryWrapperFromParams(maps);
        List allData = ((TtPacketOffInfoReportMapper)this.baseMapper).formByReadRateTime((Wrapper)wrapper);
        if (allData != null && !allData.isEmpty()) {
            wrapper.ne((Object)"errorCodePLC", (Object)3);
            List noReadData = ((TtPacketOffInfoReportMapper)this.baseMapper).formByReadRateTime((Wrapper)wrapper);
            HashMap<String, Map> noReadMap = new HashMap<String, Map>();
            if (noReadData != null && !noReadData.isEmpty()) {
                for (Map map : noReadData) {
                    noReadMap.put(map.get("title").toString(), map);
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat("#0.00");
            for (Map row : allData) {
                String platId = row.get("title").toString();
                for (String column : row.keySet()) {
                    if (column.equals("title")) continue;
                    double all = Double.parseDouble(row.get(column).toString());
                    double read = noReadMap.get(platId) != null ? Double.parseDouble(((Map)noReadMap.get(platId)).get(column).toString()) : 0.0;
                    String rate = all == 0.0 ? "-" : decimalFormat.format(read / all * 100.0) + "%";
                    row.replace(column, rate);
                }
            }
        }
        return allData;
    }

    public List<Map<String, Object>> formByDesCode(Map<String, ParamDTO> maps) {
        List result = ((TtPacketOffInfoReportMapper)this.baseMapper).formByDesCode((Wrapper)this.getQueryWrapperFromParams(maps));
        if (result != null && !result.isEmpty()) {
            try {
                int total = 0;
                for (Map data : result) {
                    total += Integer.parseInt(data.get("total").toString());
                }
                for (Map data : result) {
                    String strSum = data.get("total").toString();
                    double dRate = 0.0;
                    if (total > 0) {
                        dRate = Double.parseDouble(strSum) / (double)total;
                    }
                    data.put("rate", String.format("%.2f", dRate * 100.0) + "%");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public List<Map<String, Object>> formByErrorCode(Map<String, ParamDTO> maps) {
        this.checkDefaultValueForMap(maps);
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formByErrorCode((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    public List<Map<String, Object>> formBySlot(Map<String, ParamDTO> maps) {
        this.checkDefaultValueForMap(maps);
        return ((TtPacketOffInfoReportMapper)this.baseMapper).formBySlot((Wrapper)this.getQueryWrapperFromParams(maps));
    }

    protected void checkDefaultValueForMap(Map<String, ParamDTO> maps) {
        String time;
        if (maps == null) {
            maps = new HashMap<String, ParamDTO>();
        }
        if (!maps.containsKey(time = "packetOffTime")) {
            SimpleDateFormat formatB = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            SimpleDateFormat formatE = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            maps.put(time, new ParamDTO(2, (Object)new DateDTO(formatB.format(new Date()), formatE.format(new Date()))));
        }
    }

    protected QueryWrapper<TtPacketOffInfoReport> getQueryWrapperFromParams(Map<String, ParamDTO> maps) {
        QueryWrapper wrapper = new QueryWrapper();
        if (maps != null) {
            maps.forEach((key, paramDTO) -> {
                if (paramDTO.getValue() != null) {
                    switch (paramDTO.getType()) {
                        case 0: {
                            if (!StrUtil.isNotBlank((CharSequence)paramDTO.getValue().toString())) break;
                            String value = paramDTO.getValue().toString();
                            if (value.contains(",")) {
                                wrapper.in((Object)StrUtil.toUnderlineCase((CharSequence)key), (Object[])value.split(","));
                                break;
                            }
                            wrapper.eq((Object)StrUtil.toUnderlineCase((CharSequence)key), paramDTO.getValue());
                            break;
                        }
                        case 1: 
                        case 3: {
                            wrapper.in((Object)StrUtil.toUnderlineCase((CharSequence)key), new Object[]{paramDTO.getValue()});
                            break;
                        }
                        case 2: {
                            DateDTO dateBean = (DateDTO)CommonUtil.getGson().fromJson(CommonUtil.getGson().toJson(paramDTO.getValue()), new /* Unavailable Anonymous Inner Class!! */.getType());
                            if (dateBean == null) break;
                            ((QueryWrapper)wrapper.ge(dateBean.getBeginDate() != null, (Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)dateBean.getBeginDate())).lt(dateBean.getEndDate() != null, (Object)StrUtil.toUnderlineCase((CharSequence)key), (Object)dateBean.getEndDate());
                            break;
                        }
                    }
                }
            });
        }
        return wrapper;
    }

    public List<Map<String, Object>> execute(String sql) {
        String[] keywords;
        for (String keyword : keywords = new String[]{"master", "truncate", "insert", "delete", "update", "declare", "alert", "drop"}) {
            if (!sql.contains(keyword)) continue;
            return null;
        }
        return ((TtPacketOffInfoReportMapper)this.baseMapper).execute(sql);
    }

    public TtPacketOffInfoReportServiceImpl(TtTrashTypeMapper trashTypeMapper, SortConfig sortConfig) {
        this.trashTypeMapper = trashTypeMapper;
        this.sortConfig = sortConfig;
    }
}

