/*
 * Decompiled with CFR 0.152.
 */
package com.simba.controllers;

import com.simba.services.ScreenService;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SlotPackController {
    private static final Logger log = LoggerFactory.getLogger(SlotPackController.class);
    @Resource
    private SlotService slotService;
    @Resource
    private ScreenService screenService;

    public void onSlotPackMessage(SlotInfo slotInfo) {
        if (slotInfo == null) {
            return;
        }
        if (!slotInfo.getIsPacking().compareAndSet(false, true)) {
            log.error("This slot is packing now: [" + slotInfo.getSlotId() + "]");
            return;
        }
        this.doSlotPack(slotInfo);
        slotInfo.getIsPacking().set(false);
    }

    private void doSlotPack(SlotInfo slotInfo) {
        try {
            slotInfo.lock();
            this.printSlotPackPoint("start", slotInfo);
            boolean flag = this.slotService.slotPack(slotInfo);
            this.printSlotPackPoint("end", slotInfo);
            if (flag) {
                this.screenService.sendInfoToBigScreen(slotInfo.getSlotId(), slotInfo.getBoxInfo().getMails().size(), true);
            }
            slotInfo.resetBoxInfo();
            this.screenService.sendInfoToSlotScreen(slotInfo.getSlotId());
        }
        catch (Exception ex) {
            log.error("Handle slot pack message error -- Exception : " + ex);
        }
    }

    private void printSlotPackPoint(String point, SlotInfo slotInfo) {
        StringBuilder boxInfoBuilder = new StringBuilder(50);
        boxInfoBuilder.append("[SlotPackController.onSlotPackMessage] Slot:[");
        boxInfoBuilder.append(slotInfo.getSlotId());
        boxInfoBuilder.append("],Pack Box Code:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getBoxCode());
        boxInfoBuilder.append("],mailCount:[");
        boxInfoBuilder.append(slotInfo.getBoxInfo().getMails().size());
        boxInfoBuilder.append("],point:[");
        boxInfoBuilder.append(point);
        boxInfoBuilder.append("]");
        log.debug(boxInfoBuilder.toString());
    }
}

