/*
 * Decompiled with CFR 0.152.
 */
package com.simba.controllers;

import com.simba.common.net.NetTools;
import com.simba.common.socket.common.utils.ByteUtil;
import com.simba.databases.service.ITtPacketScanInfoService;
import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import com.simba.services.msg.FrameMsgService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlatScanController {
    private static final Logger log = LoggerFactory.getLogger(PlatScanController.class);
    private final SorterService sorterService;
    private final SortInfoService sortInfoService;
    private final SlotService slotService;
    private final ITtPacketScanInfoService packetScanInfoService;

    public void onPlatScanMessage(SortInfo sortInfo) {
        try {
            if (sortInfo.getScanType().equals("MANUAL")) {
                if (sortInfo.getComplementType().equals("manual")) {
                    this.updateSortInfo(sortInfo, true);
                    if (sortInfo.getSlotsList().isEmpty()) {
                        sortInfo.setErrorCodeSVR(2);
                    } else {
                        sortInfo.setErrorCodeSVR(0);
                    }
                } else {
                    this.updateSortInfo(sortInfo, false);
                }
                this.doSortResult(sortInfo);
            } else {
                this.requestSortInfo(sortInfo);
            }
            this.restoreScannedInfo(sortInfo);
        }
        catch (Exception ex) {
            log.error("Request sort info error: " + ex);
        }
    }

    private void requestSortInfo(SortInfo sortInfo) {
        try {
            this.sortInfoService.requestSortInfo(sortInfo);
            this.sortInfoService.handleSortInfoResult(sortInfo);
            if (sortInfo.getErrorCodeSVR() == 10) {
                log.info("Request sort info error 10: not send to plc");
                return;
            }
            this.sendScannedResultToPLC(sortInfo);
        }
        catch (Exception ex) {
            log.error("Request sort info Error -- Exception : " + ex);
        }
    }

    private void updateSortInfo(SortInfo sortInfo, boolean changeSlots) {
        try {
            String platId = sortInfo.getSorterId();
            SorterInfo sorterInfo = this.sorterService.getSorterById(platId);
            SortInfo temp = sorterInfo.getCurrentSortInfo();
            if (temp != null) {
                sortInfo.setErrorCodeSVR(temp.getErrorCodeSVR());
                sortInfo.setRoadSlot(temp.getRoadSlot());
                sortInfo.setRoadSlotName(temp.getRoadSlotName());
                if (!changeSlots) {
                    sortInfo.getSlotsList().clear();
                    for (Integer slot : temp.getSlotsList()) {
                        if (slot <= 0 || slot > this.slotService.getSlotInfoCount()) continue;
                        sortInfo.getSlotsList().add(slot);
                    }
                }
                sortInfo.setChargeWeight(temp.getChargeWeight());
                sortInfo.setServerSlotsType(temp.getServerSlotsType());
            }
        }
        catch (Exception ex) {
            log.error("Update sort info error: " + ex);
        }
    }

    private void doSortResult(SortInfo sortInfo) {
        try {
            this.sortInfoService.doSetUploadFlag(sortInfo);
            this.sortInfoService.handleSortInfoResult(sortInfo);
            this.sendScannedResultToPLC(sortInfo);
        }
        catch (Exception ex) {
            log.error("[PlatScannedController.requestSortPlan] : Error: " + ex);
        }
    }

    private void restoreScannedInfo(SortInfo sortInfo) {
        this.packetScanInfoService.saveBySortInfo(sortInfo);
    }

    private void sendScannedResultToPLC(SortInfo sortInfo) {
        byte[] replyBuffer = FrameMsgService.createSortCmdWithPlatBuffer1((SortInfo)sortInfo);
        if (replyBuffer == null) {
            return;
        }
        NetTools.getFrameServer().getClients().values().forEach(client -> {
            client.sendByteContent(replyBuffer);
            log.info("Channel-[" + client.getChannel().getRemoteAddress() + "] Send byte data-[" + ByteUtil.byteArrayToString((byte[])replyBuffer) + "]");
        });
    }

    public PlatScanController(SorterService sorterService, SortInfoService sortInfoService, SlotService slotService, ITtPacketScanInfoService packetScanInfoService) {
        this.sorterService = sorterService;
        this.sortInfoService = sortInfoService;
        this.slotService = slotService;
        this.packetScanInfoService = packetScanInfoService;
    }
}

