/*
 * Decompiled with CFR 0.152.
 */
package com.simba.controllers;

import cn.hutool.core.util.StrUtil;
import com.simba.common.command.CommandExecutor;
import com.simba.common.command.RC;
import com.simba.databases.service.ITtPacketOffInfoReportService;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.databases.service.ITtPacketOffInfoSyncService;
import com.simba.services.MonitorService;
import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.beans.SortInfo;
import com.simba.web.client.WebPacketOffCmd;
import com.simba.web.client.WebPacketScanCmd;
import com.simba.web.client.WebRecycleSlotStateCmd;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PacketOffController {
    private static final Logger log = LoggerFactory.getLogger(PacketOffController.class);
    @Resource
    private SlotService slotService;
    @Resource
    private ITtPacketOffInfoService packetOffInfoService;
    @Resource
    private ITtPacketOffInfoReportService packetOffInfoReportService;
    @Resource
    private ITtPacketOffInfoSyncService packetOffInfoSyncService;
    @Resource
    private SortInfoService sortInfoService;
    @Resource
    private MonitorService monitorService;

    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            log.info("checkSortTime start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.checkSortTime(sortInfo);
            log.info("checkSortTime end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            log.info("offerAddScanInfo start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.offerAddScanInfo(sortInfo);
            log.info("offerAddScanInfo end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            log.info("offerSortResult start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.offerSortResult(sortInfo);
            log.info("offerSortResult end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            log.info("restorePacketOff start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.restorePacketOff(sortInfo);
            log.info("restorePacketOff end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            log.info("recordSortResult start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.recordSortResult(sortInfo);
            log.info("recordSortResult end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            log.info("sendInfoToMonitor start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.sendInfoToMonitor(sortInfo);
            log.info("sendInfoToMonitor end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
        }
        catch (Exception ex) {
            log.error("Handle packet off message error -- Exception : " + ex);
        }
    }

    private void checkSortTime(SortInfo sortInfo) {
        Date packetOffTime = sortInfo.getPacketOffTime();
        if (packetOffTime == null) {
            packetOffTime = new Date();
        }
        sortInfo.setPacketOffTime(packetOffTime);
    }

    private void recordSortResult(SortInfo sortInfo) {
        try {
            StringBuilder info = new StringBuilder();
            info.append("[Key:SortResult],");
            info.append("[SorterID:").append(sortInfo.getSorterId()).append("],");
            info.append("[Barcode:").append(sortInfo.getBarcode()).append("],");
            info.append("[BarcodeList:").append(sortInfo.getBarcodeList()).append("],");
            info.append("[PlcID:").append(sortInfo.getPlcId()).append("],");
            info.append("[DroppedSlot:").append(sortInfo.getDroppedSlotId()).append("],");
            info.append("[ServerSlotId:").append(StrUtil.join((CharSequence)",", (Object[])new Object[]{sortInfo.getSlotsList()})).append("],");
            info.append("[DroppedErrorCode:").append(sortInfo.getErrorCodePLC()).append("],");
            info.append("[ServerErrorCode:").append(sortInfo.getErrorCodeSVR()).append("]");
            log.debug(info.toString());
        }
        catch (Exception ex) {
            log.error("[PacketOffDecoder.recordSortResult] Error:" + ex.getMessage());
        }
    }

    private void offerAddScanInfo(SortInfo sortInfo) {
        try {
            if (sortInfo.getUploadFlag() == -2) {
                return;
            }
            if (sortInfo.getUploadFlag() == -3) {
                return;
            }
            CommandExecutor.executorCommand((String)WebPacketScanCmd.NAME, (Object)sortInfo, (boolean)false);
        }
        catch (Exception ex) {
            log.error("Handle packet off message error -- Exception : " + ex);
        }
    }

    private void offerSortResult(SortInfo sortInfo) {
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            SlotInfo slotInfo = this.slotService.getSlotInfo(slotId);
            if (slotInfo == null) {
                sortInfo.setUploadFlag(-1);
                return;
            }
            if (sortInfo.getUploadFlag() == -2) {
                return;
            }
            if (sortInfo.getUploadFlag() == -3) {
                return;
            }
            int uploadNum = sortInfo.getUploadNum() + 1;
            String cmdName = sortInfo.getErrorCodePLC() == 0 ? WebPacketOffCmd.NAME : WebRecycleSlotStateCmd.NAME;
            RC ret = CommandExecutor.executorCommand((String)cmdName, (Object)sortInfo, (boolean)false);
            if (ret.success) {
                sortInfo.setUploadFlag(1);
            } else {
                sortInfo.setUploadFlag(0);
            }
            sortInfo.setUploadNum(uploadNum);
        }
        catch (Exception ex) {
            log.error("Handle packet off message error -- Exception : " + ex);
        }
    }

    private void restorePacketOff(SortInfo sortInfo) {
        try {
            boolean ret = this.packetOffInfoService.saveBySortInfo(sortInfo);
            if (!ret) {
                log.error("Save packet off msg error, barcode:" + sortInfo.getBarcode());
                this.sortInfoService.offerSortInfoDataToQueue(sortInfo);
            }
            if (!(ret = this.packetOffInfoReportService.saveBySortInfo(sortInfo))) {
                log.error("Save packet off report msg error, barcode:" + sortInfo.getBarcode());
            }
            if (!(ret = this.packetOffInfoSyncService.saveBySortInfo(sortInfo))) {
                log.error("Save packet off sync msg error, barcode:" + sortInfo.getBarcode());
            }
        }
        catch (Exception ex) {
            log.error("Save packet off message error -- Exception : " + ex);
        }
    }

    private void sendInfoToMonitor(SortInfo sortInfo) {
        this.monitorService.sendSortInfoToMonitor(sortInfo);
    }
}

