/*
 * Decompiled with CFR 0.152.
 */
package com.simba.controllers;

import com.simba.common.net.NetTools;
import com.simba.common.socket.common.utils.ByteUtil;
import com.simba.databases.service.ITtPacketOnInfoService;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.PacketOnInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.msg.FrameMsgService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ObrScanController {
    private static final Logger log = LoggerFactory.getLogger(ObrScanController.class);
    @Resource
    private SortInfoService sortInfoService;
    @Resource
    private SorterService sorterService;
    @Resource
    private ITtPacketOnInfoService packetOnInfoService;

    public void onSortInfoMessage(SortInfo sortInfo) {
        try {
            if (sortInfo == null) {
                return;
            }
            String carId = sortInfo.getCarId();
            if (carId == null || carId.isEmpty()) {
                return;
            }
            this.recordPackOnInfo(sortInfo);
            this.sortInfoService.addSortInfo(sortInfo);
            sortInfo.setPacketScanTime(new Date());
            int errorCode = sortInfo.getErrorCodeSVR();
            if (errorCode == 4) {
                this.sortInfoService.handleSortInfoResult(sortInfo);
            } else if (errorCode == 3) {
                this.sortInfoService.handleSortInfoResult(sortInfo);
            } else if (errorCode == 7) {
                this.sortInfoService.handleSortInfoResult(sortInfo);
            } else if (errorCode == 5) {
                this.sortInfoService.handleSortInfoResult(sortInfo);
            } else {
                this.sortInfoService.requestSortInfo(sortInfo);
                this.sortInfoService.handleSortInfoResult(sortInfo);
            }
            byte[] sortResultBuffer = FrameMsgService.createSortCmdWithCarIdBuffer((SortInfo)sortInfo);
            if (sortResultBuffer == null) {
                return;
            }
            NetTools.getFrameServer().getClients().values().forEach(client -> {
                client.sendByteContent(sortResultBuffer);
                log.info("\u8fd4\u56de\u7ed9plc \u683c\u53e3\u4fe1\u606f\u6210\u529f Channel-[" + client.getChannel().getRemoteAddress() + "] Send byte data-[" + ByteUtil.byteArrayToString((byte[])sortResultBuffer) + "]");
            });
        }
        catch (Exception ex) {
            log.error("[SortInfoController.onSortInfoMessage] Handle Sort Info Error:" + ex.getMessage());
        }
    }

    private void recordPackOnInfo(SortInfo sortInfo) {
        String carId = sortInfo.getCarId();
        PacketOnInfo packetOnInfo = this.sorterService.getPacketOnInfo(carId);
        if (packetOnInfo != null) {
            sortInfo.setSorterId(packetOnInfo.getSorterId());
            sortInfo.setSorterMode(packetOnInfo.getSorterMode());
            sortInfo.setWeight(packetOnInfo.getWeight());
            packetOnInfo.setBarcode(sortInfo.getBarcode());
            packetOnInfo.setScanMode(sortInfo.getScanMode());
            packetOnInfo.setScanType(sortInfo.getScanType());
            this.sorterService.removePacketOnInfo(carId);
            this.packetOnInfoService.saveBySortInfo(packetOnInfo);
        }
    }
}

