/*
 * Decompiled with CFR 0.152.
 */
package com.simba.controllers;

import cn.hutool.core.date.DateUtil;
import com.simba.databases.entity.TtMachineInfo;
import com.simba.databases.entity.TtMachineStatusLocal;
import com.simba.databases.service.ITtMachineInfoService;
import com.simba.databases.service.ITtMachineStatusLocalService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MachineStatusController {
    private static final Logger log = LoggerFactory.getLogger(MachineStatusController.class);
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String time;
    @Resource
    private ITtMachineStatusLocalService machineStatusLocalService;
    @Resource
    private ITtMachineInfoService machineInfoService;

    public void onMachineStateMessage(int machineStatus) {
        try {
            switch (machineStatus) {
                case 1: {
                    this.handleTurnOn();
                    break;
                }
                case 2: {
                    this.handleTurnOff("1");
                    break;
                }
                case 3: {
                    this.handleTurnOff("2");
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.error("Handle machine status message error -- Exception : " + ex);
        }
    }

    private void handleTurnOff(String type) {
        this.machineInfoService.updateById((Object)TtMachineInfo.builder().id(Integer.valueOf(1)).endTime(this.format.format(new Date())).status(type).build());
        TtMachineInfo info = (TtMachineInfo)this.machineInfoService.getById((Serializable)Integer.valueOf(1));
        if (info.getBeginTime() != null) {
            this.machineStatusLocalService.save((Object)TtMachineStatusLocal.builder().beginTime((Date)DateUtil.parse((CharSequence)info.getBeginTime())).endTime((Date)DateUtil.parse((CharSequence)info.getEndTime())).status(Integer.valueOf(Integer.parseInt(info.getStatus()))).build());
        }
    }

    private void handleTurnOn() {
        this.machineInfoService.saveOrUpdate((Object)TtMachineInfo.builder().id(Integer.valueOf(1)).beginTime(this.format.format(new Date())).status("1").build());
    }
}

