/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.net.manager;

import cn.hutool.core.util.StrUtil;
import com.simba.common.socket.common.utils.ByteUtil;
import com.simba.common.socket.framework.base.manager.handler.BaseByteServiceManager;
import com.simba.common.socket.framework.tools.ResponseTools;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameByteServiceManager
extends BaseByteServiceManager {
    private static final Logger log = LoggerFactory.getLogger(FrameByteServiceManager.class);
    private final String name = StrUtil.lowerFirst((CharSequence)this.getClass().getSimpleName());
    private int commandPoint = 2;

    public FrameByteServiceManager(int corePoolSize, int maxPoolSize) {
        super.init(corePoolSize, maxPoolSize);
    }

    protected void initServices() {
        this.loadDecoders();
    }

    protected int bindCommandPoint() {
        return this.commandPoint;
    }

    protected void printReceivedInfo(Channel channel, byte[] content) {
        String info = ByteUtil.byteArrayToString((byte[])content);
        log.info("Channel-[" + channel.getRemoteAddress() + "] Read byte data-[" + info + "]");
    }

    protected boolean examineReceivedInfo(Channel channel, byte[] content) {
        if (content[0] != 1 || content[1] != 2) {
            byte[] errorBuffer = new byte[]{2, 1, -18, 1, 13, 10};
            ResponseTools.commitResponse((Channel)channel, (byte[])errorBuffer, (boolean)true);
            log.error("The frame message must start with {01 02}");
            return false;
        }
        return true;
    }

    protected String getName() {
        return this.name;
    }

    public void setCommandPoint(int commandPoint) {
        this.commandPoint = commandPoint;
    }
}

