/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.command;

import com.simba.common.command.CommandCreator;
import com.simba.common.command.RC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandExecutor.class);
    private static final CommandCreator creator = new CommandCreator();

    public static RC executorCommand(String commandName, Object params, boolean isLog) {
        long beginTime = System.currentTimeMillis();
        RC result = creator.executeCmd(commandName, params);
        long endTime = System.currentTimeMillis();
        long diff = endTime - beginTime;
        if (isLog || diff > 3000L) {
            log.info("[" + commandName + "] \u547d\u4ee4\u6267\u884c\uff01 \u7ed3\u679c\uff1a" + result.success + ", \u8017\u65f6\uff1a" + diff + " ms");
        }
        return result;
    }

    private CommandExecutor() {
    }
}

