/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.command;

import cn.hutool.core.collection.CollectionUtil;
import com.simba.common.command.Command;
import com.simba.common.command.ICommand;
import com.simba.common.command.RC;
import com.simba.common.socket.common.utils.SpringBeanUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandCreator {
    private static final Logger log = LoggerFactory.getLogger(CommandCreator.class);
    private final ConcurrentHashMap<String, ICommand> commandList = new ConcurrentHashMap();

    public void load() {
        Map beans = SpringBeanUtils.getBeansWithAnnotation(Command.class);
        if (!beans.isEmpty()) {
            beans.forEach((key, value) -> {
                if (value instanceof ICommand) {
                    ICommand command = (ICommand)value;
                    this.commandList.put(command.getName(), command);
                }
            });
        }
    }

    public RC executeCmd(String cmdName, Object params) {
        ICommand command;
        if (CollectionUtil.isEmpty((Map)this.commandList)) {
            this.load();
        }
        if ((command = (ICommand)this.commandList.getOrDefault(cmdName, null)) == null) {
            return RC.error((int)1001);
        }
        try {
            RC result = command.run(params);
            if (!result.success) {
                log.debug("Command Executed Failed : " + command.getName());
            }
            return result;
        }
        catch (Exception e) {
            log.error("Command Executed error: " + e.getMessage());
            return RC.error((int)1002);
        }
    }
}

