/*
 * Decompiled with CFR 0.152.
 */
package com.simba;

import com.simba.services.ConfigService;
import com.simba.services.SlotService;
import com.simba.services.SorterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class ServerInitRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(ServerInitRunner.class);
    private final ConfigService configService;
    private final SlotService slotService;
    private final SorterService sorterService;

    public void run(ApplicationArguments args) {
        try {
            this.configService.loadBasicConfig();
            this.slotService.init();
            this.sorterService.init();
            String startInfo = "[Init Runner] Init Components Successfully";
            log.info(startInfo);
        }
        catch (Exception ex) {
            log.error("[Init Runner] catch error :" + ex.getMessage());
        }
    }

    public ServerInitRunner(ConfigService configService, SlotService slotService, SorterService sorterService) {
        this.configService = configService;
        this.slotService = slotService;
        this.sorterService = sorterService;
    }
}

