/*
 * Decompiled with CFR 0.152.
 */
package com.simba.web.service.config;

import com.simba.common.socket.common.utils.SpringBeanUtils;
import com.simba.common.socket.framework.bean.ClientBean;
import com.simba.common.socket.framework.config.NetConfigProperties;
import com.simba.web.service.config.EwmJsonServiceManager;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="net", value={"enable"}, havingValue="true")
@ConditionalOnBean(value={SpringBeanUtils.class})
public class EwmSocketConfig {
    private final NetConfigProperties netConfigProperties;
    private EwmJsonServiceManager ewmJsonServiceManager;

    private ClientBean getClientBean(String key) {
        List list = this.netConfigProperties.getClients();
        if (list != null) {
            for (ClientBean bean : list) {
                if (!bean.getKey().equals(key)) continue;
                return bean;
            }
        }
        return null;
    }

    public EwmJsonServiceManager buildJsonServiceManager(String key) {
        int corePoolSize = 5;
        int maxPoolSize = 5;
        boolean printReceiveLog = false;
        String routeKey = "0";
        ClientBean clientBean = this.getClientBean(key);
        if (clientBean != null) {
            corePoolSize = clientBean.getHandleCorePoolSize();
            maxPoolSize = clientBean.getHandleMaxPoolSize();
            printReceiveLog = clientBean.isPrintReceiveLog();
            routeKey = clientBean.getRouthKey();
        }
        EwmJsonServiceManager ewmJsonServiceManager = new EwmJsonServiceManager(corePoolSize, maxPoolSize);
        ewmJsonServiceManager.setPrintReceivedLog(printReceiveLog);
        ewmJsonServiceManager.setRouteKey(routeKey);
        return ewmJsonServiceManager;
    }

    @Bean
    public EwmJsonServiceManager wtcoJsonServiceManager() {
        if (this.ewmJsonServiceManager == null) {
            this.ewmJsonServiceManager = this.buildJsonServiceManager("wtco");
        }
        return this.ewmJsonServiceManager;
    }

    @Bean
    public EwmJsonServiceManager wtcrJsonServiceManager() {
        if (this.ewmJsonServiceManager == null) {
            this.ewmJsonServiceManager = this.buildJsonServiceManager("wtcr");
        }
        return this.ewmJsonServiceManager;
    }

    @Bean
    public EwmJsonServiceManager wtccJsonServiceManager() {
        if (this.ewmJsonServiceManager == null) {
            this.ewmJsonServiceManager = this.buildJsonServiceManager("wtcc");
        }
        return this.ewmJsonServiceManager;
    }

    @Bean
    public EwmJsonServiceManager strqJsonServiceManager() {
        if (this.ewmJsonServiceManager == null) {
            this.ewmJsonServiceManager = this.buildJsonServiceManager("strq");
        }
        return this.ewmJsonServiceManager;
    }

    @Bean
    public EwmJsonServiceManager stJsonServiceManager() {
        if (this.ewmJsonServiceManager == null) {
            this.ewmJsonServiceManager = this.buildJsonServiceManager("st");
        }
        return this.ewmJsonServiceManager;
    }

    @Bean
    public EwmJsonServiceManager stwmJsonServiceManager() {
        if (this.ewmJsonServiceManager == null) {
            this.ewmJsonServiceManager = this.buildJsonServiceManager("stwm");
        }
        return this.ewmJsonServiceManager;
    }

    public EwmSocketConfig(NetConfigProperties netConfigProperties) {
        this.netConfigProperties = netConfigProperties;
    }
}

