/*
 * Decompiled with CFR 0.152.
 */
package com.simba.web.client;

import com.simba.common.command.Command;
import com.simba.common.command.ICommand;
import com.simba.common.command.RC;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.SortConfig;
import com.simba.wbapi.ApiClientExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command
public class WebRecycleSlotStateCmd
implements ICommand {
    private static final Logger log = LoggerFactory.getLogger(WebRecycleSlotStateCmd.class);
    public static final String NAME = WebRecycleSlotStateCmd.class.getName();
    private final SortConfig sortConfig;
    private final ApiClientExample apiClientExample;

    public String getName() {
        return NAME;
    }

    public RC run(Object params) {
        SortInfo sortInfo = (SortInfo)params;
        try {
            if (this.sortConfig.isDebug()) {
                log.error("Upload recycle slot error: debug mode doesn't upload data!");
                return RC.error((int)1004);
            }
            log.info("WebRecycleSlotStateCmd sendSortInfoToWcs start barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            this.sendSortInfoToWcs(sortInfo);
            log.info("WebRecycleSlotStateCmd sendSortInfoToWcs end barcode {}, carId {}, slot {}", new Object[]{sortInfo.getBarcode(), sortInfo.getCarId(), sortInfo.getSlotsList()});
            return RC.ok();
        }
        catch (Exception e) {
            log.error("Upload recycle slot error: " + e);
            return RC.error((int)1006);
        }
    }

    public void sendSortInfoToWcs(SortInfo sortInfo) {
        String barcode = sortInfo.getBarcode();
        int droppedSlotId = sortInfo.getDroppedSlotId();
        try {
            int sortPlaceId = this.sortConfig.getSortPlaceId();
            int employeeId = Integer.parseInt(null == sortInfo.getWorkerNo() ? "0" : sortInfo.getWorkerNo());
            String result = this.apiClientExample.saveItemSortingResult(barcode, droppedSlotId, sortPlaceId, employeeId);
            log.info("sendSortInfoToSap barcode{},carId{}, content:{}", new Object[]{barcode, sortInfo.getCarId(), result});
        }
        catch (Exception e) {
            log.error("sortInfo barcode {} sendSortInfoToSap error:{}", (Object)barcode, (Object)e.getMessage());
        }
    }

    public WebRecycleSlotStateCmd(SortConfig sortConfig, ApiClientExample apiClientExample) {
        this.sortConfig = sortConfig;
        this.apiClientExample = apiClientExample;
    }
}

