/*
 * Decompiled with CFR 0.152.
 */
package com.simba.wbapi.udp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.simba.wbapi.udp.SorterItem;
import com.simba.wbapi.udp.SorterStatus;
import com.simba.wbapi.udp.UdpCommunicator;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UdpCommunicator {
    private static final Logger log = LoggerFactory.getLogger(UdpCommunicator.class);
    private final String targetHost;
    private final int targetPort;
    private final ObjectMapper objectMapper;

    public UdpCommunicator(@Value(value="${udp.target.host}") String udpTargetHost, @Value(value="${udp.target.port}") Integer udpTargetPort) {
        if (udpTargetHost == null || udpTargetHost.trim().isEmpty()) {
            throw new IllegalArgumentException("UDP\u76ee\u6807\u4e3b\u673a\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5udp.target.host");
        }
        if (udpTargetPort == null || udpTargetPort < 1 || udpTargetPort > 65535) {
            throw new IllegalArgumentException("UDP\u76ee\u6807\u7aef\u53e3\u914d\u7f6e\u65e0\u6548\uff08\u5fc5\u987b\u4e3a1-65535\uff09\uff0c\u8bf7\u68c0\u67e5udp.target.port\uff0c\u5f53\u524d\u503c\uff1a" + udpTargetPort);
        }
        this.targetHost = udpTargetHost.trim();
        this.targetPort = udpTargetPort;
        this.objectMapper = new ObjectMapper();
    }

    public void sendItemData(SorterItem item) {
        if (item == null) {
            log.warn("\u53d1\u9001\u9879\u76ee\u626b\u63cf\u6570\u636e\u5931\u8d25\uff1a\u6570\u636e\u5bf9\u8c61\u4e3anull");
            return;
        }
        try {
            String json = this.objectMapper.writeValueAsString((Object)item);
            log.info("\u51c6\u5907\u53d1\u9001\u9879\u76ee\u626b\u63cf\u6570\u636e\uff1a{}", (Object)json);
            this.sendUdpPacket(json);
        }
        catch (JsonProcessingException e) {
            throw new UdpCommunicationException("\u9879\u76ee\u626b\u63cf\u6570\u636e\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            throw new UdpCommunicationException("\u9879\u76ee\u626b\u63cf\u6570\u636e\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public void sendStatusData(SorterStatus status) {
        if (status == null) {
            log.warn("\u53d1\u9001\u72b6\u6001\u53d8\u66f4\u6570\u636e\u5931\u8d25\uff1a\u72b6\u6001\u5bf9\u8c61\u4e3anull");
            return;
        }
        try {
            String json = this.objectMapper.writeValueAsString((Object)status);
            log.info("\u51c6\u5907\u53d1\u9001\u72b6\u6001\u53d8\u66f4\u6570\u636e\uff1a{}", (Object)json);
            this.sendUdpPacket(json);
        }
        catch (JsonProcessingException e) {
            throw new UdpCommunicationException("\u72b6\u6001\u53d8\u66f4\u6570\u636e\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            throw new UdpCommunicationException("\u72b6\u6001\u53d8\u66f4\u6570\u636e\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    private void sendUdpPacket(String data) {
        InetAddress address;
        if (data == null || data.isEmpty()) {
            log.warn("UDP\u53d1\u9001\u6570\u636e\u4e3a\u7a7a\uff0c\u5ffd\u7565\u53d1\u9001");
            return;
        }
        byte[] buffer = data.getBytes(StandardCharsets.UTF_8);
        try {
            address = InetAddress.getByName(this.targetHost);
        }
        catch (UnknownHostException e) {
            throw new UdpCommunicationException("\u89e3\u6790\u76ee\u6807\u4e3b\u673a\u5730\u5740\u5931\u8d25\uff1a" + this.targetHost, (Throwable)e);
        }
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, this.targetPort);
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(3000);
            socket.send(packet);
            log.info("UDP\u6570\u636e\u53d1\u9001\u6210\u529f | \u76ee\u6807: {}:{} | \u6570\u636e\u957f\u5ea6: {}\u5b57\u8282", new Object[]{address.getHostAddress(), this.targetPort, buffer.length});
        }
        catch (SocketTimeoutException e) {
            throw new UdpCommunicationException("UDP\u53d1\u9001\u8d85\u65f6\uff08\u76ee\u6807\uff1a" + this.targetHost + ":" + this.targetPort + "\uff09", (Throwable)e);
        }
        catch (PortUnreachableException e) {
            throw new UdpCommunicationException("\u76ee\u6807\u7aef\u53e3\u4e0d\u53ef\u8fbe\uff08" + this.targetHost + ":" + this.targetPort + "\uff09", (Throwable)e);
        }
        catch (SocketException e) {
            throw new UdpCommunicationException("UDP\u5957\u63a5\u5b57\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            throw new UdpCommunicationException("UDP\u6570\u636e\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }
}

