/*
 * Decompiled with CFR 0.152.
 */
package com.simba.wbapi.udp;

import com.simba.services.params.SortConfig;
import com.simba.wbapi.udp.SorterItem;
import com.simba.wbapi.udp.SorterStatus;
import com.simba.wbapi.udp.UdpCommunicator;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SorterMonitorSystem {
    private static final Logger log = LoggerFactory.getLogger(SorterMonitorSystem.class);
    @Resource
    private SortConfig sortConfig;
    @Resource
    private UdpCommunicator udpCommunicator;
    private static final int TIMEOUT_SECONDS = 3;
    private static final int TIMEOUT_MILLIS = 3000;

    public void sendBarCodeToSap(String barcode, String placeId, Integer operation) {
        SorterItem item = new SorterItem();
        item.setSorterId("layer" + this.sortConfig.getArea());
        item.setPlaceId(placeId);
        item.setAction(operation);
        item.setBarcode(barcode);
        item.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        try {
            this.udpCommunicator.sendItemData(item);
            log.info("\u9879\u76ee\u626b\u63cf\u6570\u636e\u53d1\u9001\u6210\u529f{}", (Object)item);
        }
        catch (Exception e) {
            log.info("\u9879\u76ee\u626b\u63cf\u6570\u636e\u53d1\u9001\u5931\u8d25{}", (Object)item);
            log.info("\u9879\u76ee\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void sendStatusToSap(Integer operation) {
        SorterStatus status = new SorterStatus();
        status.setSorterId("layer" + this.sortConfig.getArea());
        status.setStatus(operation);
        status.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        try {
            this.udpCommunicator.sendStatusData(status);
            log.info("\u72b6\u6001\u53d8\u66f4\u6570\u636e\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u72b6\u6001\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public boolean checkUdpPortReachable(String host, int port) {
        return this.isUdpPortReachable(host, port, 3000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUdpPortReachable(String host, int port, int timeout) {
        try (DatagramChannel channel = DatagramChannel.open();){
            channel.configureBlocking(true);
            channel.socket().setSoTimeout(timeout);
            InetSocketAddress address = new InetSocketAddress(host, port);
            byte[] probe = "UDP_PROBE".getBytes();
            channel.send(ByteBuffer.wrap(probe), address);
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            channel.receive(buffer);
            boolean bl = buffer.position() > 0;
            return bl;
        }
        catch (SocketTimeoutException e) {
            log.info("\u7aef\u53e3\u68c0\u6d4b\u8d85\u65f6");
            return false;
        }
        catch (PortUnreachableException e) {
            log.info("\u7aef\u53e3\u4e0d\u53ef\u8fbe");
            return false;
        }
        catch (Exception e) {
            log.info("\u68c0\u6d4b\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
    }
}

