/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import cn.hutool.core.collection.CollectionUtil;
import com.simba.common.command.CommandExecutor;
import com.simba.common.command.RC;
import com.simba.databases.entity.TtPacketOffInfo;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.beans.SortInfo;
import com.simba.web.client.WebPacketOffCmd;
import com.simba.web.client.WebRecycleSlotStateCmd;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class UploadTask {
    private static final Logger log = LoggerFactory.getLogger(UploadTask.class);
    private final SlotService slotService;
    private final ITtPacketOffInfoService packetOffInfoService;

    @Scheduled(initialDelay=5000L, fixedDelay=10000L)
    public void doTask() {
        try {
            this.uploadSortResult();
        }
        catch (Exception ex) {
            log.error("Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void uploadSortResult() {
        List result = this.packetOffInfoService.listPacketByNoUpload();
        if (CollectionUtil.isEmpty((Collection)result)) {
            return;
        }
        for (TtPacketOffInfo info : result) {
            if (info.getId() == null) continue;
            int droppedSlotId = info.getDroppedSlot();
            String slotId = String.valueOf(droppedSlotId);
            SlotInfo slotInfo = this.slotService.getSlotInfo(slotId);
            if (slotInfo == null) {
                info.setUploadFlag(Integer.valueOf(-1));
                this.packetOffInfoService.updateUploadFlagById(info.getUploadFlag().intValue(), info.getUploadNum().intValue(), info.getId());
                continue;
            }
            if (info.getUploadFlag() == -2 || info.getUploadFlag() == -3) continue;
            String cmdName = info.getErrorCodePlc() == 0 ? WebPacketOffCmd.NAME : WebRecycleSlotStateCmd.NAME;
            SortInfo sortInfo = new SortInfo();
            sortInfo.setSortResultId(info.getId());
            sortInfo.setBarcode(info.getBarcode());
            sortInfo.setSorterId(info.getSorterId());
            sortInfo.setDroppedSlotId(info.getDroppedSlot().intValue());
            sortInfo.setBoxCode(info.getBoxCode());
            sortInfo.setErrorCodePLC(info.getErrorCodePlc().intValue());
            sortInfo.setPacketOffTime(info.getPacketOffTime());
            sortInfo.setWeight(info.getWeight());
            sortInfo.setUploadFlag(info.getUploadFlag().intValue());
            sortInfo.setUploadNum(info.getUploadNum().intValue());
            sortInfo.setLength(info.getLength());
            sortInfo.setWidth(info.getWidth());
            sortInfo.setHeight(info.getHeight());
            sortInfo.setVolume(info.getVolume());
            sortInfo.setRoadSlot(info.getRoadSlot());
            RC rc = CommandExecutor.executorCommand((String)cmdName, (Object)sortInfo, (boolean)false);
            if (rc.success) {
                info.setUploadFlag(Integer.valueOf(1));
            } else {
                info.setUploadFlag(Integer.valueOf(0));
            }
            info.setUploadNum(Integer.valueOf(info.getUploadNum() + 1));
            this.packetOffInfoService.updateUploadFlagById(info.getUploadFlag().intValue(), info.getUploadNum().intValue(), info.getId());
        }
    }

    public UploadTask(SlotService slotService, ITtPacketOffInfoService packetOffInfoService) {
        this.slotService = slotService;
        this.packetOffInfoService = packetOffInfoService;
    }
}

