/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import cn.hutool.core.util.StrUtil;
import com.simba.databases.service.ITtPacketOffInfoReportService;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.services.beans.SortInfo;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class ExpiredTask {
    private static final Logger log = LoggerFactory.getLogger(ExpiredTask.class);
    private final BlockingQueue<SortInfo> queue = new LinkedBlockingQueue();
    @Resource
    private ITtPacketOffInfoService packetOffInfoService;
    @Resource
    private ITtPacketOffInfoReportService packetOffInfoReportService;

    public void offerPacketExpiredToQueue(SortInfo info) {
        if (info == null) {
            return;
        }
        this.queue.offer(info);
    }

    @Scheduled(initialDelay=5000L, fixedDelay=2000L)
    private void updatePacketExpiredList() {
        try {
            SortInfo info = (SortInfo)this.queue.take();
            if (StrUtil.isBlank((CharSequence)info.getBarcode())) {
                return;
            }
            this.packetOffInfoService.updateBarcodeInfoExpired(info.getBarcode());
            this.packetOffInfoReportService.updateBarcodeInfoExpired(info.getBarcode());
        }
        catch (Exception e) {
            log.error("Handle packet expired error:  " + e);
        }
    }
}

