/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.beans.SortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class DataSaveTask {
    private static final Logger log = LoggerFactory.getLogger(DataSaveTask.class);
    private final SortInfoService sortInfoService;
    private final SlotService slotService;

    @Scheduled(fixedDelay=2000L)
    protected void doSortTask() {
        try {
            SortInfo sortInfo = (SortInfo)this.sortInfoService.getFailedQueue().take();
            this.sortInfoService.restore(sortInfo);
            log.debug("[SortInfoService.restoreData] Try restore packet off again. [Barcode:" + sortInfo.getBarcode() + "]");
        }
        catch (Exception e) {
            log.error("Restore packet off message in sort info error -- Exception : " + e);
        }
    }

    @Scheduled(fixedDelay=2000L)
    protected void doSlotTask() {
        try {
            SlotInfo slotInfo = (SlotInfo)this.slotService.getFailedQueue().take();
            this.slotService.slotPack(slotInfo);
            log.debug("[DataRestoreTask.doSlotTask] Start to repack : [ " + slotInfo.getSlotId() + ":" + slotInfo.getBoxInfo().getBoxCode() + " ]");
        }
        catch (Exception e) {
            log.error("[DataRestoreTask.doSlotTask] Catch a exception: " + e.getMessage());
        }
    }

    public DataSaveTask(SortInfoService sortInfoService, SlotService slotService) {
        this.sortInfoService = sortInfoService;
        this.slotService = slotService;
    }
}

