/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import com.simba.common.util.TimeUtil;
import com.simba.databases.service.ITtPacketOffInfoReportService;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.databases.service.ITtPacketOnInfoService;
import com.simba.databases.service.ITtPacketScanInfoService;
import com.simba.databases.service.ITtSlotPackInfoService;
import com.simba.services.params.SorterParams;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class DataClearTask {
    private static final Logger log = LoggerFactory.getLogger(DataClearTask.class);
    private final SorterParams sorterParams;
    private final ITtPacketOffInfoService packetOffInfoService;
    private final ITtPacketOffInfoReportService packetOffInfoReportService;
    private final ITtPacketOnInfoService packetOnInfoService;
    private final ITtPacketScanInfoService packetScanInfoService;
    private final ITtSlotPackInfoService slotPackInfoService;

    @Scheduled(initialDelay=5000L, fixedDelay=20000L)
    private void doTask() {
        try {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            if (hour == this.sorterParams.getDeleteDataTime()) {
                this.doClearData();
            }
        }
        catch (Exception ex) {
            log.error("[deleteOverTimeSortData] : Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public void doClearData() {
        this.doClearPacketOff(this.sorterParams.getRestorePacketOffDays());
        this.doClearSlotPack(this.sorterParams.getRestoreSlotPackDays());
        this.doClearPacketOn(this.sorterParams.getRestorePacketOffDays());
        this.doClearPacketScan(this.sorterParams.getRestorePacketOffDays());
        this.doClearPackageOffReport(this.sorterParams.getRestorePacketReportDays());
    }

    private void doClearPackageOffReport(int restoreDays) {
        boolean flag = this.packetOffInfoReportService.deleteRecord(TimeUtil.getDeleteTimestamp((int)restoreDays));
        if (flag) {
            log.error("Delete package off report data successful");
        }
    }

    private void doClearPacketOff(int restoreDays) {
        boolean flag = this.packetOffInfoService.deleteRecord(TimeUtil.getDeleteTimestamp((int)restoreDays));
        if (flag) {
            log.error("Delete package off data successful");
        }
    }

    private void doClearPacketOn(int restoreDays) {
        boolean flag = this.packetOnInfoService.deleteRecord(TimeUtil.getDeleteTimestamp((int)restoreDays));
        if (flag) {
            log.error("Delete package on data successful");
        }
    }

    private void doClearPacketScan(int restoreDays) {
        boolean flag = this.packetScanInfoService.deleteRecord(TimeUtil.getDeleteTimestamp((int)restoreDays));
        if (flag) {
            log.error("Delete package scan data successful");
        }
    }

    private void doClearSlotPack(int restoreDays) {
        boolean flag = this.slotPackInfoService.deleteRecord(TimeUtil.getDeleteTimestamp((int)restoreDays));
        if (flag) {
            log.error("Delete slot pack data successful");
        }
    }

    public DataClearTask(SorterParams sorterParams, ITtPacketOffInfoService packetOffInfoService, ITtPacketOffInfoReportService packetOffInfoReportService, ITtPacketOnInfoService packetOnInfoService, ITtPacketScanInfoService packetScanInfoService, ITtSlotPackInfoService slotPackInfoService) {
        this.sorterParams = sorterParams;
        this.packetOffInfoService = packetOffInfoService;
        this.packetOffInfoReportService = packetOffInfoReportService;
        this.packetOnInfoService = packetOnInfoService;
        this.packetScanInfoService = packetScanInfoService;
        this.slotPackInfoService = slotPackInfoService;
    }
}

