/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import com.simba.common.net.NetTools;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.msg.FrameMsgService;
import com.simba.services.params.MachineParams;
import java.util.Comparator;
import net.logstash.logback.encoder.org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class ConfigSyncTask {
    private static final Logger log = LoggerFactory.getLogger(ConfigSyncTask.class);
    private final MachineParams params;
    private final SlotService slotService;

    @Scheduled(initialDelay=5000L, fixedDelay=3000L)
    public void doTask() {
        try {
            this.sendMachineParams();
            this.sendSlotSortLockStatus();
        }
        catch (Exception ex) {
            log.error("Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void sendMachineParams() {
        try {
            byte[] machineParamsBuf = FrameMsgService.createMachineParamsBuffer((MachineParams)this.params);
            NetTools.getFrameServer().getClients().values().forEach(client -> client.sendByteContent(machineParamsBuf));
        }
        catch (Exception ex) {
            log.error("[SendMachineParams] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void sendSlotSortLockStatus() {
        try {
            Byte[] slotLockStatus = (Byte[])this.slotService.getSlotInfoList().stream().sorted(Comparator.comparingInt(e -> Integer.parseInt(e.getSlotId()))).map(SlotInfo::getLockStatus).toArray(Byte[]::new);
            byte[] replyBuffer = FrameMsgService.createSlotSoftLockStatusBuffer((byte[])ArrayUtils.toPrimitive((Byte[])slotLockStatus));
            NetTools.getFrameServer().getClients().values().forEach(client -> client.sendByteContent(replyBuffer));
        }
        catch (Exception ex) {
            log.error("[SendSlotLockStatus] Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public ConfigSyncTask(MachineParams params, SlotService slotService) {
        this.params = params;
        this.slotService = slotService;
    }
}

