/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import cn.hutool.core.collection.CollectionUtil;
import com.simba.databases.entity.TtSlotConfig;
import com.simba.databases.service.ITtSlotConfigService;
import com.simba.services.ConfigService;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class ConfigReloadTask {
    private static final Logger log = LoggerFactory.getLogger(ConfigReloadTask.class);
    private final ConfigService configService;
    private final SlotService slotService;
    private final ITtSlotConfigService slotConfigService;

    @Scheduled(initialDelay=5000L, fixedDelay=100000L)
    public void doTask() {
        try {
            this.reloadBasicConfig();
            this.reloadSlotConfig();
        }
        catch (Exception ex) {
            log.error("Catch an exception [" + ex.getMessage() + "]");
        }
    }

    private void reloadBasicConfig() {
        this.configService.loadBasicConfig();
    }

    private void reloadSlotConfig() {
        try {
            List slotConfigList = this.slotConfigService.list();
            if (CollectionUtil.isEmpty((Collection)slotConfigList)) {
                return;
            }
            for (TtSlotConfig slot : slotConfigList) {
                String slotId = slot.getSlotId();
                int slotDistrict = slot.getSlotDistrict();
                int slotWhetherUpload = slot.getSlotWhetherUpload();
                SlotInfo slotInfo = this.slotService.getSlotInfo(slotId);
                if (slotInfo == null) continue;
                slotInfo.setSlotDistrict(slotDistrict);
                slotInfo.setSlotWhetherUpload(slotWhetherUpload);
            }
        }
        catch (Exception ex) {
            log.error("[SlotStatusTask.reloadSlotConfig] reload slots config error: " + ex);
        }
    }

    private void reloadTshSlots() {
        try {
            this.slotService.reloadTshSlots();
        }
        catch (Exception ex) {
            log.error("Catch an exception [" + ex.getMessage() + "]");
        }
    }

    public ConfigReloadTask(ConfigService configService, SlotService slotService, ITtSlotConfigService slotConfigService) {
        this.configService = configService;
        this.slotService = slotService;
        this.slotConfigService = slotConfigService;
    }
}

