/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import com.simba.controllers.PacketOffController;
import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.SorterService;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class ClearOverTimeTask {
    private static final Logger log = LoggerFactory.getLogger(ClearOverTimeTask.class);
    private final SortInfoService sortInfoService;
    private final SlotService slotService;
    private final SorterService sorterService;
    private final PacketOffController packetOffController;

    @Scheduled(initialDelay=5000L, fixedDelay=2000L)
    public void doTask() {
        try {
            this.handlerOverTimePacketOnInfo();
        }
        catch (Exception ex) {
            log.error("Catch an exception [" + ex.getMessage() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerOverTimePacketOnInfo() {
        long currentTime = System.currentTimeMillis();
        for (SortInfo info : this.sortInfoService.getSortInfos().values()) {
            long packetOnTime = info.getCurrentTime();
            long spanTime = currentTime - packetOnTime;
            if (spanTime <= 1200000L) continue;
            String plcKey = info.getCarId();
            try {
                List slots;
                if (info.getErrorCodeSVR() == 0) {
                    info.setErrorCodePLC(6);
                    slots = this.slotService.getTrashSlots(6, info.getSorterId());
                    info.setDroppedSlotId(slots.isEmpty() ? 0 : (Integer)slots.get(0));
                } else {
                    info.setErrorCodePLC(info.getErrorCodeSVR());
                    slots = info.getSlotsList();
                    info.setDroppedSlotId(slots.isEmpty() ? 0 : (Integer)slots.get(0));
                }
                info.setPacketOffTime(new Date());
                SorterInfo sorterInfo = this.sorterService.getSorterById(info.getSorterId());
                if (sorterInfo != null) {
                    this.sortInfoService.doSetNoUploadByErrorCode(info, sorterInfo.getNoUploadError());
                }
                this.packetOffController.onPacketOffMessage(info);
            }
            catch (Exception e) {
                log.error("[WheelSortInfoManager.handlerOverTimePacketOnInfo] Auto remove SortInfo Error: Car ID:" + plcKey + ", Msg:" + e.getMessage());
            }
            finally {
                this.sortInfoService.removeSortInfo(plcKey);
                log.debug("[WheelSortInfoManager.handlerOverTimePacketOnInfo] Auto remove SortInfo. Car ID:" + plcKey);
            }
        }
    }

    public ClearOverTimeTask(SortInfoService sortInfoService, SlotService slotService, SorterService sorterService, PacketOffController packetOffController) {
        this.sortInfoService = sortInfoService;
        this.slotService = slotService;
        this.sorterService = sorterService;
        this.packetOffController = packetOffController;
    }
}

