/*
 * Decompiled with CFR 0.152.
 */
package com.simba.task;

import cn.hutool.core.collection.CollectionUtil;
import com.simba.common.command.CommandExecutor;
import com.simba.common.command.RC;
import com.simba.common.util.CommonUtil;
import com.simba.databases.entity.TtSlotPackInfo;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.databases.service.ITtSlotPackInfoService;
import com.simba.services.beans.SlotInfo;
import com.simba.web.client.WebPackSlotCmd;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class BoxPackOfferTask {
    private static final Logger log = LoggerFactory.getLogger(BoxPackOfferTask.class);
    private final ITtSlotPackInfoService slotPackInfoService;
    private final ITtPacketOffInfoService packetOffInfoService;

    @Scheduled(initialDelay=5000L, fixedDelay=10000L)
    private void doTask() {
        List slotPacks = this.slotPackInfoService.getNeedUploadData();
        if (CollectionUtil.isEmpty((Collection)slotPacks)) {
            return;
        }
        for (TtSlotPackInfo boxInfo : slotPacks) {
            if (boxInfo.getId().isEmpty()) continue;
            boxInfo.setSlotId(null);
            if (CommonUtil.isNull((String)boxInfo.getBoxCode())) {
                boxInfo.setUploadFlag(Integer.valueOf(-1));
                this.slotPackInfoService.updateById((Object)boxInfo);
                continue;
            }
            List mails = this.packetOffInfoService.listPacketByBoxCode(boxInfo.getBoxCode());
            if (CollectionUtil.isEmpty((Collection)mails)) {
                boxInfo.setUploadFlag(Integer.valueOf(-1));
                this.slotPackInfoService.updateById((Object)boxInfo);
                continue;
            }
            boxInfo.setUploadNum(Integer.valueOf(boxInfo.getUploadNum() + 1));
            boxInfo.setUploadFlag(Integer.valueOf(1));
            SlotInfo slotInfo = SlotInfo.builder().slotId(boxInfo.getSlotId()).build();
            slotInfo.getBoxInfo().setBoxCode(boxInfo.getBoxCode());
            slotInfo.getBoxInfo().setPlanId(boxInfo.getPlanId());
            slotInfo.getBoxInfo().setRoadSlot(boxInfo.getRoadSlot());
            slotInfo.getBoxInfo().setMails(mails);
            RC ret = CommandExecutor.executorCommand((String)WebPackSlotCmd.NAME, (Object)slotInfo, (boolean)false);
            if (!ret.success) {
                boxInfo.setUploadFlag(Integer.valueOf(0));
            }
            this.slotPackInfoService.updateById((Object)boxInfo);
        }
    }

    public BoxPackOfferTask(ITtSlotPackInfoService slotPackInfoService, ITtPacketOffInfoService packetOffInfoService) {
        this.slotPackInfoService = slotPackInfoService;
        this.packetOffInfoService = packetOffInfoService;
    }
}

