/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.msg;

import com.simba.common.socket.common.utils.FrameUtil;
import com.simba.services.beans.SortInfo;
import com.simba.services.params.MachineParams;
import com.simba.services.params.SortCommonDefines;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FrameMsgService {
    private static final Logger log = LoggerFactory.getLogger(FrameMsgService.class);

    private static int buildByteBuffer(byte[] buffer, int position, int len, Object value) {
        byte[] buf;
        switch (len) {
            case 1: {
                if (value instanceof Integer) {
                    buf = new byte[]{(byte)((Integer)value).intValue()};
                    break;
                }
                buf = new byte[]{(Byte)value};
                break;
            }
            case 2: {
                buf = new byte[2];
                try {
                    FrameUtil.setShortBigEndian((int)0, (int)((Integer)value), (byte[])buf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("setShortBigEndian{}", (Throwable)e);
                }
                break;
            }
            case 4: {
                buf = new byte[4];
                FrameUtil.setIntBigEndian((int)0, (int)((Integer)value), (byte[])buf);
                break;
            }
            case 8: {
                buf = new byte[8];
                FrameUtil.setLongBigEndian((int)0, (long)((Long)value), (byte[])buf);
                break;
            }
            default: {
                buf = new byte[]{};
            }
        }
        System.arraycopy(buf, 0, buffer, position, buf.length);
        return position += buf.length;
    }

    private static int buildByteBuffer(byte[] buffer, int position, String value) {
        byte[] buf = value.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(buf, 0, buffer, position, buf.length);
        return position += buf.length;
    }

    private static int buildByteBuffer(byte[] buffer, int position, byte[] buf) {
        System.arraycopy(buf, 0, buffer, position, buf.length);
        return position += buf.length;
    }

    private static byte[] buildFinalBuffer(byte command, byte[] buffer) {
        if (buffer == null) {
            buffer = new byte[]{};
        }
        byte[] finalBuffer = new byte[buffer.length + 5];
        int position = 0;
        position = FrameMsgService.buildByteBuffer((byte[])finalBuffer, (int)position, (byte[])SortCommonDefines.REPLY_HEADER);
        position = FrameMsgService.buildByteBuffer((byte[])finalBuffer, (int)position, (byte[])new byte[]{command});
        position = FrameMsgService.buildByteBuffer((byte[])finalBuffer, (int)position, (byte[])buffer);
        FrameMsgService.buildByteBuffer((byte[])finalBuffer, (int)position, (byte[])SortCommonDefines.REPLY_END);
        return finalBuffer;
    }

    public static byte[] createSystemTimeToBuffer() {
        byte[] timeBuffer = new byte[8];
        FrameMsgService.buildByteBuffer((byte[])timeBuffer, (int)0, (int)8, (Object)System.currentTimeMillis());
        return timeBuffer;
    }

    public static byte[] createCheckTimeBuffer() {
        byte[] buffer = new byte[9];
        int position = 0;
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)8, (Object)FrameMsgService.createSystemTimeToBuffer());
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
        return FrameMsgService.buildFinalBuffer((byte)17, (byte[])buffer);
    }

    public static byte[] createMachineParamsBuffer(MachineParams params) {
        try {
            byte[] buffer = new byte[21];
            int position = 0;
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getMaxLoopCircles());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getMaxScanNumber());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getClearMode());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)params.getSorterSpeed());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getStartWarnTime());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getClearStopTime());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getClearStopCircles());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getNoreadWarn());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getSaveElecTime());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getPidaiInterval());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)params.getPidaiCheckTime());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
            return FrameMsgService.buildFinalBuffer((byte)38, (byte[])buffer);
        }
        catch (Exception ex) {
            log.error("[SendMachineParams] Create machine params buffer error: " + ex);
            return null;
        }
    }

    public static byte[] createResetPlatBuffer(int platId) {
        byte[] buffer = new byte[10];
        int position = 0;
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)platId);
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
        return FrameMsgService.buildFinalBuffer((byte)68, (byte[])buffer);
    }

    public static byte[] createSlotSoftLockBuffer(int slotId) {
        byte[] buffer = new byte[12];
        int position = 0;
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slotId);
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
        return FrameMsgService.buildFinalBuffer((byte)18, (byte[])buffer);
    }

    public static byte[] createSlotSoftLockStatusBuffer(byte[] slotLockStatus) {
        int bufferLen = 9 + slotLockStatus.length;
        byte[] buffer = new byte[bufferLen];
        int position = 0;
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])slotLockStatus);
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
        return FrameMsgService.buildFinalBuffer((byte)20, (byte[])buffer);
    }

    public static byte[] createSlotSoftUnLockBuffer(int slotId) {
        byte[] buffer = new byte[12];
        int position = 0;
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slotId);
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)0);
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
        position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
        return FrameMsgService.buildFinalBuffer((byte)19, (byte[])buffer);
    }

    public static byte[] createSortCmdWithCarIdBuffer(SortInfo sortInfo) {
        try {
            int slotsNum = sortInfo.getSlotsList().size();
            byte[] buffer = new byte[17 + 2 * slotsNum];
            int position = 0;
            log.info("\u4e0a\u4ef6\u540e\u53d1\u9001\u683c\u53e3\u4fe1\u606f:carId:{},obr:{},roadSlotValue:{},slotsNum:{},sortInfo slotsList:{}", new Object[]{sortInfo.getCarId(), sortInfo.getObr(), sortInfo.getRoadSlotValue(), slotsNum, sortInfo.getSlotsList()});
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)Integer.parseInt(sortInfo.getCarId()));
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getObr());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)sortInfo.getRoadSlotValue());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)slotsNum);
            Iterator iterator = sortInfo.getSlotsList().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slot);
            }
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getSortMode());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getErrorCodeSVR());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
            return FrameMsgService.buildFinalBuffer((byte)7, (byte[])buffer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("[CreateSortInfoBuffer] Create sort info buffer error: " + ex);
            return null;
        }
    }

    public static byte[] createSortCmdWithPlatBuffer(SortInfo sortInfo) {
        try {
            String barcode = sortInfo.getBarcode();
            if (barcode == null) {
                barcode = "NoneCode";
            }
            int slotsNum = sortInfo.getSlotsList().size();
            int barcodeLen = barcode.length();
            int bufferLen = 17 + barcodeLen + 2 * slotsNum;
            byte[] buffer = new byte[bufferLen];
            int position = 0;
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)Integer.parseInt(sortInfo.getSorterId()));
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)3);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)barcodeLen);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (String)barcode);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)sortInfo.getRoadSlotValue());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)slotsNum);
            Iterator iterator = sortInfo.getSlotsList().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slot);
            }
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getSortMode());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getErrorCodeSVR());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
            return FrameMsgService.buildFinalBuffer((byte)4, (byte[])buffer);
        }
        catch (Exception ex) {
            log.error("[CreateSortInfoWithPlat] Create sort info buffer error: " + ex);
            return null;
        }
    }

    public static byte[] createSortCmdWithPlatBuffer1(SortInfo sortInfo) {
        try {
            int val = 10;
            String barcode = sortInfo.getBarcode();
            if (barcode == null) {
                barcode = "NoneCode";
            }
            int slotsNum = sortInfo.getSlotsList().size();
            int barcodeLen = barcode.length();
            int bufferLen = 17 + barcodeLen + 2 * slotsNum;
            byte[] buffer = new byte[bufferLen];
            int position = 0;
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)Integer.parseInt(sortInfo.getSorterId()));
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)val);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)barcodeLen);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (String)barcode);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)sortInfo.getRoadSlotValue());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)slotsNum);
            Iterator iterator = sortInfo.getSlotsList().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slot);
            }
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getSortMode());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getErrorCodeSVR());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
            return FrameMsgService.buildFinalBuffer((byte)4, (byte[])buffer);
        }
        catch (Exception ex) {
            log.error("[CreateSortInfoWithPlat] Create sort info buffer error: " + ex);
            return null;
        }
    }

    public static byte[] createTshSlotsToPlcBuffer(List<Integer> slots, int errorCode) {
        try {
            if (slots == null) {
                return null;
            }
            byte[] buffer = new byte[11 + 2 * slots.size()];
            int position = 0;
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)errorCode);
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)slots.size());
            for (int slot : slots) {
                position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slot);
            }
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (byte[])FrameMsgService.createSystemTimeToBuffer());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)1);
            return FrameMsgService.buildFinalBuffer((byte)-16, (byte[])buffer);
        }
        catch (Exception ex) {
            log.error("[CreateTshSlotsToPLC] Send sort plan items error:" + ex);
            return null;
        }
    }

    public static byte[] createResetSlotsToPlcBuffer(SortInfo sortInfo) {
        try {
            List slots = sortInfo.getSlotsList();
            if (slots == null) {
                log.error("[ResetSlotsToPLC] Reset sort slot error: slots is null");
                return null;
            }
            int slotSize = slots.size();
            byte[] buffer = new byte[6 + 2 * slotSize];
            int position = 0;
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)Integer.parseInt(sortInfo.getCarId()));
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)sortInfo.getRoadSlotValue());
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)slotSize);
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)2, (Object)slot);
            }
            position = FrameMsgService.buildByteBuffer((byte[])buffer, (int)position, (int)1, (Object)sortInfo.getErrorCodeSVR());
            return FrameMsgService.buildFinalBuffer((byte)-13, (byte[])buffer);
        }
        catch (Exception ex) {
            log.error("[ResetSlotsToPLC] Send sort slot error:" + ex.getMessage());
            return null;
        }
    }

    private FrameMsgService() {
    }
}

