/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.simba.databases.entity.TtSorterConfig;
import com.simba.databases.service.ITtSorterConfigService;
import com.simba.services.SlotService;
import com.simba.services.SortInfoService;
import com.simba.services.beans.PacketOnInfo;
import com.simba.services.beans.PacketScanInfo;
import com.simba.services.beans.SortInfo;
import com.simba.services.beans.SorterInfo;
import com.simba.services.params.SortConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SorterService {
    private static final Logger log = LoggerFactory.getLogger(SorterService.class);
    private final ConcurrentHashMap<String, SorterInfo> sorters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SorterInfo> sortersClients = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, PacketOnInfo> packetOnInfos = new ConcurrentHashMap();
    @Resource
    private SortInfoService sortInfoService;
    @Resource
    private SlotService slotService;
    @Resource
    private ITtSorterConfigService sorterConfigService;
    @Resource
    private SortConfig sortConfig;

    public void init() {
        try {
            String area = this.sortConfig.getArea();
            log.info("init sorterConfig area: " + area);
            List sorterConfigList = this.sorterConfigService.list((Wrapper)Wrappers.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)area), TtSorterConfig::getArea, (Object)area));
            if (sorterConfigList == null || sorterConfigList.isEmpty()) {
                log.error("Init lines config error -- Exception : Can't find line config");
                return;
            }
            ArrayList<String> lineIds = new ArrayList<String>();
            for (TtSorterConfig sorter : sorterConfigList) {
                SorterInfo info = SorterInfo.builder().sorterId(sorter.getSorterId()).sorterName(sorter.getSorterName()).packet(sorter.getPacket() == 1).upload(sorter.getUpload() == 1).noUploadError(Arrays.asList(sorter.getNoUploadError().split(","))).isAutoSj(sorter.getAutoSj() == 1).sorterStatus(0).clientSorterId(sorter.getClientSorterId()).area(sorter.getArea()).build();
                lineIds.add(sorter.getSorterId());
                this.sorters.put(info.getSorterId(), info);
                this.sortersClients.put(info.getClientSorterId(), info);
            }
            log.info("Init lines config successful [" + StrUtil.join((CharSequence)",", (Object[])new Object[]{lineIds}) + "]");
        }
        catch (Exception e) {
            log.error("Init lines config error -- Exception : " + e);
        }
    }

    public SorterInfo getSorterById(String sorterId) {
        if (CollectionUtil.isEmpty((Map)this.sorters)) {
            this.init();
        }
        if (null == sorterId) {
            return null;
        }
        if (sorterId.length() > 2) {
            return this.getSorterByClientId(sorterId);
        }
        return this.sorters.getOrDefault(sorterId, null);
    }

    private SorterInfo getSorterByClientId(String sorterClientId) {
        if (CollectionUtil.isEmpty((Map)this.sortersClients)) {
            this.init();
        }
        return this.sortersClients.getOrDefault(sorterClientId, null);
    }

    public SortInfo handleScannedCommand(PacketScanInfo scanInfo) {
        if (scanInfo == null) {
            return null;
        }
        String platId = scanInfo.getSorterId();
        SorterInfo sorterInfo = this.getSorterById(platId);
        if (sorterInfo == null) {
            return null;
        }
        try {
            SortInfo unDefinedSortInfo = this.sortInfoService.createSortInfo();
            unDefinedSortInfo.setBarcode(scanInfo.getBarcode());
            unDefinedSortInfo.getBarcodeList().add(scanInfo.getBarcode());
            unDefinedSortInfo.setSorterId(scanInfo.getSorterId());
            unDefinedSortInfo.setSorterMode(scanInfo.getSorterMode());
            unDefinedSortInfo.setScanMode(scanInfo.getScanMode());
            unDefinedSortInfo.setScanType(scanInfo.getScanType());
            unDefinedSortInfo.setPacketScanTime(scanInfo.getScanTime());
            unDefinedSortInfo.setComplementType(scanInfo.getComplementType());
            unDefinedSortInfo.setWorkerNo(scanInfo.getWorkerNo());
            unDefinedSortInfo.setWeight(scanInfo.getWeight());
            unDefinedSortInfo.setImgUuid(scanInfo.getImgUuid());
            unDefinedSortInfo.setAutoSj(sorterInfo.isAutoSj());
            unDefinedSortInfo.setBoxTypeCode(sorterInfo.getMailType());
            if (scanInfo.getScanType().equals("MANUAL") && scanInfo.getComplementType().equals("manual")) {
                for (String slot : scanInfo.getSlots()) {
                    int slotI = Integer.parseInt(slot);
                    if (slotI <= 0 || slotI > this.slotService.getSlotInfoCount()) continue;
                    unDefinedSortInfo.getSlotsList().add(slotI);
                }
            }
            if (!sorterInfo.isUpload()) {
                unDefinedSortInfo.setUploadFlag(-2);
            }
            sorterInfo.getSortInfoQueue().put(scanInfo.getBarcode(), unDefinedSortInfo);
            return unDefinedSortInfo;
        }
        catch (Exception ex) {
            log.error("Handle scanner message with simple mode error: " + ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacketOnCommand(PacketOnInfo packetOnInfo) {
        if (packetOnInfo == null) {
            return;
        }
        String platId = packetOnInfo.getSorterId();
        SorterInfo sorterInfo = this.getSorterById(platId);
        if (sorterInfo == null) {
            return;
        }
        SortInfo toDefineSortInfo = null;
        String barcode = packetOnInfo.getBarcode();
        try {
            if (barcode == null) {
                return;
            }
            if (!sorterInfo.getSortInfoQueue().containsKey(barcode)) {
                return;
            }
            toDefineSortInfo = (SortInfo)sorterInfo.getSortInfoQueue().get(barcode);
            toDefineSortInfo.setCarId(packetOnInfo.getCarId());
            toDefineSortInfo.setSorterMode(packetOnInfo.getSorterMode());
            toDefineSortInfo.setSorterId(platId);
            toDefineSortInfo.setPlcId(packetOnInfo.getPlcId());
            toDefineSortInfo.setWeight(packetOnInfo.getWeight());
            packetOnInfo.setScanMode(toDefineSortInfo.getScanMode());
            packetOnInfo.setScanType(toDefineSortInfo.getScanType());
            toDefineSortInfo.setPacketOnTime(new Date());
            this.sortInfoService.addSortInfo(toDefineSortInfo);
            log.info("Barcode:" + toDefineSortInfo.getBarcode() + " ErrorCode: " + toDefineSortInfo.getErrorCodeSVR());
        }
        catch (Exception ex) {
            log.error("Handle packet on message error -- Exception : " + ex);
        }
        finally {
            if (barcode != null) {
                sorterInfo.getSortInfoQueue().remove(barcode);
            }
        }
    }

    public void addPacketOnInfo(String carId, PacketOnInfo packetOnInfo) {
        if (carId == null || carId.isEmpty() || packetOnInfo == null) {
            return;
        }
        this.packetOnInfos.put(carId, packetOnInfo);
    }

    public PacketOnInfo getPacketOnInfo(String carId) {
        if (carId == null || carId.isEmpty()) {
            return null;
        }
        return (PacketOnInfo)this.packetOnInfos.get(carId);
    }

    public void removePacketOnInfo(String carId) {
        if (carId == null || carId.isEmpty()) {
            return;
        }
        this.packetOnInfos.remove(carId);
    }

    private SorterService() {
    }

    public ConcurrentHashMap<String, SorterInfo> getSorters() {
        return this.sorters;
    }

    public ConcurrentHashMap<String, PacketOnInfo> getPacketOnInfos() {
        return this.packetOnInfos;
    }
}

