/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import cn.hutool.core.collection.CollectionUtil;
import com.simba.common.command.CommandExecutor;
import com.simba.common.command.RC;
import com.simba.common.net.NetTools;
import com.simba.common.socket.common.utils.ByteUtil;
import com.simba.common.util.CommonUtil;
import com.simba.common.util.TimeUtil;
import com.simba.databases.entity.TtPacketOffInfo;
import com.simba.databases.entity.TtSlotConfig;
import com.simba.databases.entity.TtTrashSlots;
import com.simba.databases.service.ITtPacketOffInfoService;
import com.simba.databases.service.ITtSlotConfigService;
import com.simba.databases.service.ITtSlotPackInfoService;
import com.simba.databases.service.ITtTrashSlotsService;
import com.simba.services.beans.SlotInfo;
import com.simba.services.beans.TrashSlotsInfo;
import com.simba.services.msg.FrameMsgService;
import com.simba.web.client.WebPackSlotCmd;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SlotService {
    private static final Logger log = LoggerFactory.getLogger(SlotService.class);
    private final ConcurrentHashMap<String, SlotInfo> slotInfoList = new ConcurrentHashMap();
    private final BlockingQueue<SlotInfo> failedQueue = new LinkedBlockingQueue();
    private final TrashSlotsInfo trashSlotsInfo = new TrashSlotsInfo();
    @Resource
    private ITtSlotConfigService slotConfigService;
    @Resource
    private ITtTrashSlotsService trashSlotsService;
    @Resource
    private ITtSlotPackInfoService slotPackInfoService;
    @Resource
    private ITtPacketOffInfoService packetOffInfoService;

    public boolean checkSlotIsTrash(String slotId) {
        return this.trashSlotsInfo.getTrashSlotList().containsKey(slotId);
    }

    public SlotInfo getSlotInfo(String key) {
        return (SlotInfo)this.slotInfoList.get(key.toLowerCase());
    }

    public int getSlotInfoCount() {
        return this.slotInfoList.size();
    }

    public Collection<SlotInfo> getSlotInfoList() {
        return this.slotInfoList.values();
    }

    public List<Integer> getTrashSlots(int errorCode, String sorterId) {
        Map sorterInfo;
        Map errorInfo = this.trashSlotsInfo.getTrashSLotListByTypeSorter();
        if (errorInfo.containsKey(errorCode) && (sorterInfo = (Map)errorInfo.get(errorCode)).containsKey(sorterId)) {
            return (List)sorterInfo.get(sorterId);
        }
        return this.trashSlotsInfo.getTrashSlotListByType().getOrDefault(errorCode, null);
    }

    public void init() {
        try {
            this.initSlotInfos();
            this.initTrashSlots();
        }
        catch (Exception ex) {
            log.error("Init slot info  error: " + ex);
        }
    }

    public void offerSlotInfoDataToQueue(SlotInfo slotInfo) {
        try {
            SlotInfo newSlotInfo = SlotInfo.builder().build();
            newSlotInfo.cloneFrom(slotInfo);
            this.failedQueue.offer(newSlotInfo);
        }
        catch (Exception e) {
            log.error("offer slot info to restore: " + e.getMessage());
        }
    }

    public void registerTrashSlot() {
        for (List slotValue : this.trashSlotsInfo.getTrashSlotListByType().values()) {
            this.addToTrashSlotList(slotValue);
        }
        for (Map sorterValue : this.trashSlotsInfo.getTrashSLotListByTypeSorter().values()) {
            for (List slotValue : sorterValue.values()) {
                this.addToTrashSlotList(slotValue);
            }
        }
    }

    private void addToTrashSlotList(List<Integer> slots) {
        if (slots != null) {
            ConcurrentHashMap trashSlotInfos = this.trashSlotsInfo.getTrashSlotList();
            for (Integer slot : slots) {
                SlotInfo slotInfo;
                String slotId = String.valueOf(slot);
                if (trashSlotInfos.containsKey(slotId) || (slotInfo = (SlotInfo)this.slotInfoList.get(slotId)) == null) continue;
                trashSlotInfos.put(slotId, slotInfo);
            }
        }
    }

    public void reloadTshSlots() {
        this.initTrashSlots();
    }

    public void renewSlotInfo() {
        for (SlotInfo info : this.getSlotInfoList()) {
            info.setTotalMailCount(0);
            info.setCurrentMailCount(0);
        }
    }

    public void sendSlotSoftLockToPLC(SlotInfo slotInfo) {
        try {
            byte[] buffer = FrameMsgService.createSlotSoftLockBuffer((int)Integer.parseInt(slotInfo.getSlotId()));
            NetTools.getFrameServer().getClients().values().forEach(client -> {
                client.sendByteContent(buffer);
                log.info("Channel-[" + client.getChannel().getRemoteAddress() + "] Send byte data-[" + ByteUtil.byteArrayToString((byte[])buffer) + "]");
            });
        }
        catch (Exception e) {
            log.error("[sendSlotStatusToPlc] Found an exception:" + e.getMessage());
        }
    }

    public void sendSlotSoftUnLockToPLC(SlotInfo slotInfo) {
        try {
            byte[] buffer = FrameMsgService.createSlotSoftUnLockBuffer((int)Integer.parseInt(slotInfo.getSlotId()));
            NetTools.getFrameServer().getClients().values().forEach(client -> {
                client.sendByteContent(buffer);
                log.info("Channel-[" + client.getChannel().getRemoteAddress() + "] Send byte data-[" + ByteUtil.byteArrayToString((byte[])buffer) + "]");
            });
        }
        catch (Exception e) {
            log.error("[sendSlotStatusToPlc] Found an exception:" + e.getMessage());
        }
    }

    public void sendTshSlotsToPLC() {
        ConcurrentHashMap list = this.trashSlotsInfo.getTrashSlotListByType();
        for (Integer errorCode : list.keySet()) {
            if (errorCode == 0) continue;
            byte[] buffer = FrameMsgService.createTshSlotsToPlcBuffer((List)((List)list.get(errorCode)), (int)errorCode);
            NetTools.getFrameServer().getClients().values().forEach(client -> client.sendByteContent(buffer));
        }
    }

    private void initTrashSlots() {
        this.trashSlotsInfo.clear();
        List trashSlots = this.trashSlotsService.list();
        if (CollectionUtil.isEmpty((Collection)trashSlots)) {
            log.error("Load trash slots failed!");
            return;
        }
        for (TtTrashSlots trashSlot : trashSlots) {
            int slotId = trashSlot.getSlotId();
            int typeId = trashSlot.getTypeId();
            String sorterId = trashSlot.getSorterId();
            if (CommonUtil.isNull((String)sorterId)) {
                this.trashSlotsInfo.getOrAdd(typeId).add(slotId);
                continue;
            }
            if (!sorterId.contains(",")) {
                this.trashSlotsInfo.getOrAdd(typeId, sorterId).add(slotId);
                continue;
            }
            String[] sorterIdList = sorterId.split(",");
            List slots = null;
            for (String sorterIdItem : sorterIdList) {
                if (CommonUtil.isNull((String)sorterIdItem)) continue;
                if (slots == null) {
                    slots = this.trashSlotsInfo.getOrAdd(typeId, sorterIdItem);
                }
                slots.add(slotId);
            }
        }
        this.registerTrashSlot();
    }

    private void initSlotInfos() {
        this.slotInfoList.clear();
        List slotConfigList = this.slotConfigService.list();
        for (TtSlotConfig slotConfig : slotConfigList) {
            SlotInfo slotInfo = SlotInfo.builder().slotId(slotConfig.getSlotId()).slotDistrict(slotConfig.getSlotDistrict().intValue()).slotWhetherUpload(slotConfig.getSlotWhetherUpload().intValue()).build();
            slotInfo.resetBoxInfo();
            this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
        }
        log.debug("[SlotService] Current slot number : [" + this.slotInfoList.size() + "]");
    }

    public boolean slotPack(SlotInfo slotInfo) {
        if (slotInfo == null) {
            return false;
        }
        try {
            long beginTime = System.currentTimeMillis();
            SlotInfo.BoxInfo boxInfo = slotInfo.getBoxInfo();
            log.debug("[SlotService.pack] Packing slot. [BoxCode:" + boxInfo.getBoxCode() + "]");
            boolean res = this.checkSlotIsTrash(slotInfo.getSlotId());
            if (res) {
                slotInfo.setCurrentMailCount(0);
                return false;
            }
            if (slotInfo.getSlotWhetherUpload() != 0) {
                log.debug("This Slot Shouldn't Pack : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
                return false;
            }
            String boxCode = boxInfo.getBoxCode();
            if (boxCode == null || boxCode.isEmpty()) {
                log.debug("Slot Box Code Is Null : [" + slotInfo.getSlotId() + "]");
                slotInfo.resetBoxInfo();
                return false;
            }
            List mails = this.packetOffInfoService.listPacketByBoxCode(boxCode);
            boxInfo.setMails(mails);
            if (CollectionUtil.isEmpty((Collection)mails)) {
                log.debug("Query Packet Off Count is Zero");
                slotInfo.setCurrentMailCount(0);
                return false;
            }
            boxInfo.setPlanId("");
            boxInfo.setRoadSlot(((TtPacketOffInfo)boxInfo.getMails().get(0)).getRoadSlot());
            Timestamp createTime = TimeUtil.createCurrentTimeStamp();
            boxInfo.setCreateTime(createTime.toString());
            res = this.slotPackInfoService.saveBySlotInfo(slotInfo);
            if (!res) {
                log.debug("Insert Slot Pack Record In SlotInfo Failed ");
                this.offerSlotInfoDataToQueue(slotInfo);
                return false;
            }
            int uploadNum = boxInfo.getUploadNum() + 1;
            boxInfo.setUploadNum(uploadNum);
            boxInfo.setUploadFlag(1);
            boxInfo.setBoxType("success");
            RC rc = CommandExecutor.executorCommand((String)WebPackSlotCmd.NAME, (Object)slotInfo, (boolean)false);
            if (!rc.success) {
                log.debug("Upload Slot Pack To Remote Failed\uff01");
                boxInfo.setUploadFlag(0);
                boxInfo.setBoxType("remote failed");
            }
            this.slotPackInfoService.updateByBoxCode(boxInfo);
            this.slotPackInfoService.updateDuration(System.currentTimeMillis() - beginTime, boxCode);
            return true;
        }
        catch (Exception ex) {
            log.error("Handle Slot Pack Message In SlotInfo Error -- Exception : " + ex);
            return false;
        }
    }

    private SlotService() {
    }

    public BlockingQueue<SlotInfo> getFailedQueue() {
        return this.failedQueue;
    }
}

