/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import com.simba.common.socket.framework.tools.ResponseTools;
import com.simba.services.beans.SortInfo;
import java.util.HashMap;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    private Channel channel;

    private boolean checkChannelInvalid() {
        if (this.channel == null) {
            log.error("Send barcode info to monitor service failure: unregistered");
            return true;
        }
        if (!this.channel.isConnected()) {
            log.error("Send barcode info to monitor service failure: not connected");
            return true;
        }
        return false;
    }

    public void sendSortInfoToMonitor(SortInfo info) {
        if (this.checkChannelInvalid()) {
            return;
        }
        if (info != null) {
            HashMap<String, Object> responseMap = new HashMap<String, Object>();
            responseMap.put("ServiceName", "PacketOffInfo");
            responseMap.put("barcode", info.getBarcode());
            responseMap.put("errorSvr", info.getErrorCodeSVR());
            responseMap.put("errorPlc", info.getErrorCodePLC());
            responseMap.put("serverSlots", info.getSlotsList());
            responseMap.put("droppedSlot", info.getDroppedSlotId());
            responseMap.put("boxCode", info.getBoxCode());
            responseMap.put("obr", info.getObr());
            responseMap.put("layer", "1");
            ResponseTools.commitResponse((Channel)this.channel, responseMap, (boolean)false);
        }
    }

    public void sendDelayInfoToMonitor(String type, String operator, long delay, boolean result) {
        if (this.checkChannelInvalid()) {
            return;
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("ServiceName", "DelayInfo");
        responseMap.put("operator", operator);
        responseMap.put("delay", delay);
        responseMap.put("type", type);
        responseMap.put("result", result);
        ResponseTools.commitResponse((Channel)this.channel, responseMap, (boolean)false);
    }

    private MonitorService() {
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

