/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import com.simba.databases.service.ITtBasicConfigService;
import com.simba.services.params.MachineParams;
import com.simba.services.params.SorterParams;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    @Resource
    private MachineParams machineParams;
    @Resource
    private SorterParams sorterParams;
    @Resource
    private ITtBasicConfigService basicConfigService;

    public void loadBasicConfig() {
        try {
            Map configMap = this.basicConfigService.getConfig();
            if (!configMap.isEmpty()) {
                this.setBasicConfigs(configMap);
            }
        }
        catch (Exception ex) {
            log.error("[SorterParameter.initSortParams] init sorter params error: " + ex);
        }
    }

    private int getIntValue(Map<String, String> configMap, String key, int defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private boolean getBooleanValue(Map<String, String> configMap, String key, boolean defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private String getStringValue(Map<String, String> configMap, String key, String defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private void setBasicConfigs(Map<String, String> configMap) {
        this.machineParams.setRunStatus(this.getStringValue(configMap, "runStatus", "none"));
        this.machineParams.setMaxLoopCircles(this.getIntValue(configMap, "maxTurnNumber", 3));
        this.machineParams.setMaxScanNumber(this.getIntValue(configMap, "maxScanNumber", 3));
        this.machineParams.setClearMode(this.getIntValue(configMap, "clearMode", 1));
        this.machineParams.setSorterSpeed(this.getIntValue(configMap, "sorterSpeed", 15));
        this.machineParams.setStartWarnTime(this.getIntValue(configMap, "startWarnTime", 12));
        this.machineParams.setClearStopTime(this.getIntValue(configMap, "clearStopTime", 5));
        this.machineParams.setClearStopCircles(this.getIntValue(configMap, "clearStopCircles", 4));
        this.machineParams.setNoreadWarn(this.getIntValue(configMap, "noreadWarn", 98));
        this.machineParams.setSaveElecTime(this.getIntValue(configMap, "saveElecTime", 12));
        this.machineParams.setPidaiInterval(this.getIntValue(configMap, "pidaiInterval", 12));
        this.machineParams.setPidaiCheckTime(this.getIntValue(configMap, "pidaiCheckTime", 12));
        this.machineParams.setServerId(this.getStringValue(configMap, "serverId", "1"));
        this.machineParams.setDeviceId(this.getStringValue(configMap, "deviceId", "none"));
        this.machineParams.setWorkshopCode(this.getStringValue(configMap, "workshopCode", "none"));
        this.machineParams.setCenterSituation(this.getStringValue(configMap, "centerSituation", "none"));
        this.sorterParams.setLogSaveDays(this.getIntValue(configMap, "logSaveDays", 30));
        this.sorterParams.setCheckBarcode(this.getBooleanValue(configMap, "checkBarcode", true));
        this.sorterParams.setUploadNum(this.getIntValue(configMap, "uploadNum", 3));
        this.sorterParams.setMultiCodeCheck(this.getBooleanValue(configMap, "multiCodeCheck", false));
        this.sorterParams.setRestorePacketOffDays(this.getIntValue(configMap, "restorePacketOffDays", 3));
        this.sorterParams.setRestorePacketReportDays(this.getIntValue(configMap, "restorePacketReportDays", 2));
        this.sorterParams.setRestoreSlotPackDays(this.getIntValue(configMap, "restoreSlotPackDays", 5));
        this.sorterParams.setRestoreBoxDays(this.getIntValue(configMap, "restoreBoxDays", 5));
        this.sorterParams.setDeleteDataTime(this.getIntValue(configMap, "deleteDataTime", 12));
        this.sorterParams.setSyncDataTime(this.getIntValue(configMap, "syncDataTime", 5));
        this.sorterParams.setSapUrl(this.getStringValue(configMap, "sapUrl", ""));
    }

    private ConfigService() {
    }
}

