/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services;

import com.simba.services.beans.SortInfo;
import com.simba.services.params.SortConfig;
import com.simba.services.params.SorterParams;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BarcodeService {
    private static final Logger log = LoggerFactory.getLogger(BarcodeService.class);
    @Resource
    private SorterParams sorterParams;
    @Resource
    private SortConfig sortConfig;

    public boolean checkBarcodeListValid(SortInfo info) {
        List barcodeList = info.getBarcodeList();
        if (!this.sorterParams.isMultiCodeCheck()) {
            return true;
        }
        if (barcodeList.isEmpty()) {
            return false;
        }
        if (barcodeList.size() == 1) {
            return true;
        }
        if (this.sortConfig.getBarcodeMode() == 1) {
            return false;
        }
        List list = barcodeList.stream().distinct().collect(Collectors.toList());
        return list.size() <= 1;
    }

    public boolean checkBarcodeValid(String barcode) {
        boolean ret;
        if (!this.sorterParams.isCheckBarcode()) {
            return true;
        }
        try {
            ret = true;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private BarcodeService() {
    }
}

