/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.services.params.MachineParams;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class SortJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(SortJsonService.class);
    private final MachineParams machineParams;

    public String getName() {
        return "MailSortInfo";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        HashMap<String, Object> sortInfoMap = new HashMap<String, Object>();
        sortInfoMap.put(routeKey, this.getName());
        try {
            Map request = (Map)content;
            String barcode = request.get("barcode").toString();
            sortInfoMap.put("result", true);
            sortInfoMap.put("response", "");
        }
        catch (Exception ex) {
            sortInfoMap.put("result", false);
            sortInfoMap.put("response", "error:" + ex.getMessage());
            log.error("Sort Json Service Error " + ex.getMessage());
        }
        this.renderJson(channel, sortInfoMap);
    }

    public SortJsonService(MachineParams machineParams) {
        this.machineParams = machineParams;
    }
}

