/*
 * Decompiled with CFR 0.152.
 */
package com.simba.handle.plat;

import com.simba.common.socket.framework.annotation.NetJsonService;
import com.simba.common.socket.framework.base.service.BaseJsonService;
import com.simba.controllers.SlotUnlockController;
import com.simba.services.SlotService;
import com.simba.services.beans.SlotInfo;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NetJsonService(managerNames={"platDefaultJsonServiceManager"})
public class SlotUnLockJsonService
extends BaseJsonService {
    private static final Logger log = LoggerFactory.getLogger(SlotUnLockJsonService.class);
    private final SlotService slotService;
    private final SlotUnlockController slotUnlockController;

    public boolean isLog() {
        return true;
    }

    public String getName() {
        return "UnLockSlot";
    }

    public void handleRequest(Channel channel, Object content, String routeKey) {
        try {
            Map request = (Map)content;
            String slotId = request.get("slotId").toString();
            String type = request.get("type").toString();
            SlotInfo slotInfo = this.slotService.getSlotInfo(slotId);
            if (slotInfo != null) {
                slotInfo.setSlotType("1");
                if (type.equals("packet")) {
                    this.slotUnlockController.onSlotUnlockMessage(slotInfo);
                } else {
                    slotInfo.unlock();
                }
            }
        }
        catch (Exception e) {
            log.error("UnLock Slot Error " + e.getMessage());
        }
    }

    public SlotUnLockJsonService(SlotService slotService, SlotUnlockController slotUnlockController) {
        this.slotService = slotService;
        this.slotUnlockController = slotUnlockController;
    }
}

